"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiCompressedRadio = exports.EuiRadio = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _classnames = _interopRequireDefault(require("classnames"));
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var EuiRadio = function EuiRadio(_ref) {
  var className = _ref.className,
    id = _ref.id,
    name = _ref.name,
    checked = _ref.checked,
    label = _ref.label,
    value = _ref.value,
    onChange = _ref.onChange,
    disabled = _ref.disabled,
    compressed = _ref.compressed,
    autoFocus = _ref.autoFocus,
    labelProps = _ref.labelProps,
    rest = (0, _objectWithoutProperties2.default)(_ref, ["className", "id", "name", "checked", "label", "value", "onChange", "disabled", "compressed", "autoFocus", "labelProps"]);
  var classes = (0, _classnames.default)('euiRadio', {
    'euiRadio--noLabel': !label,
    'euiRadio--compressed': compressed
  }, className);
  var labelClasses = (0, _classnames.default)('euiRadio__label', labelProps === null || labelProps === void 0 ? void 0 : labelProps.className);
  var optionalLabel;
  if (label) {
    optionalLabel = /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({}, labelProps, {
      className: labelClasses,
      htmlFor: id
    }), label);
  }
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest), /*#__PURE__*/_react.default.createElement("input", {
    className: "euiRadio__input",
    type: "radio",
    id: id,
    name: name,
    value: value,
    checked: checked,
    onChange: onChange,
    disabled: disabled,
    autoFocus: autoFocus
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "euiRadio__circle"
  }), optionalLabel);
};

// @internal
exports.EuiRadio = EuiRadio;
EuiRadio.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  autoFocus: _propTypes.default.bool,
  /**
     * When `true` creates a shorter height radio row
     */
  /**
     * When `true` creates a shorter height radio row
     */
  /**
     * When `true` creates a shorter height radio row
     */
  compressed: _propTypes.default.bool,
  name: _propTypes.default.string,
  value: _propTypes.default.string,
  checked: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onChange: _propTypes.default.any.isRequired,
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  }),
  label: _propTypes.default.node,
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string.isRequired])
};
// @internal
var EuiCompressedRadio = function EuiCompressedRadio(props) {
  return /*#__PURE__*/_react.default.createElement(EuiRadio, (0, _extends2.default)({}, props, {
    compressed: true
  }));
};
exports.EuiCompressedRadio = EuiCompressedRadio;
EuiCompressedRadio.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,
  label: _propTypes.default.node,
  id: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.string.isRequired]),
  autoFocus: _propTypes.default.bool,
  /**
     * When `true` creates a shorter height radio row
     */
  /**
     * When `true` creates a shorter height radio row
     */
  compressed: _propTypes.default.bool,
  name: _propTypes.default.string,
  value: _propTypes.default.string,
  checked: _propTypes.default.bool,
  disabled: _propTypes.default.bool,
  onChange: _propTypes.default.oneOfType([_propTypes.default.any, _propTypes.default.any.isRequired]),
  /**
     * Object of props passed to the <label/>
     */
  /**
     * Object of props passed to the <label/>
     */
  labelProps: _propTypes.default.shape({
    className: _propTypes.default.string,
    "aria-label": _propTypes.default.string,
    "data-test-subj": _propTypes.default.string
  })
};