/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.data;

import java.util.List;
import lombok.Generated;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.neuralsearch.sparse.common.IteratorWrapper;
import org.opensearch.neuralsearch.sparse.data.DocumentCluster;

public class PostingClusters
implements Accountable {
    private final List<DocumentCluster> clusters;
    private final int size;

    public PostingClusters(List<DocumentCluster> clusters) {
        this.clusters = clusters;
        if (clusters == null) {
            this.size = 0;
        } else {
            int count = 0;
            for (DocumentCluster cluster : clusters) {
                count += cluster.size();
            }
            this.size = count;
        }
    }

    public IteratorWrapper<DocumentCluster> iterator() {
        return new IteratorWrapper<DocumentCluster>(this.clusters.iterator());
    }

    public long ramBytesUsed() {
        long ramUsed = RamUsageEstimator.shallowSizeOfInstance(PostingClusters.class);
        for (DocumentCluster cluster : this.clusters) {
            ramUsed += cluster.ramBytesUsed();
        }
        return ramUsed;
    }

    @Generated
    public List<DocumentCluster> getClusters() {
        return this.clusters;
    }

    @Generated
    public int getSize() {
        return this.size;
    }
}

