/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.redirector;

import org.gradle.api.internal.tasks.testing.DefaultTestOutputEvent;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.redirector.StandardOutputRedirector;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.internal.time.Clock;

public class TestOutputRedirector {
    private final StandardOutputRedirector redirector;
    Forwarder outForwarder;
    Forwarder errForwarder;

    public TestOutputRedirector(Clock clock, TestResultProcessor processor, StandardOutputRedirector redirector) {
        this.redirector = redirector;
        this.outForwarder = new Forwarder(clock, processor, TestOutputEvent.Destination.StdOut);
        this.errForwarder = new Forwarder(clock, processor, TestOutputEvent.Destination.StdErr);
    }

    public void startRedirecting() {
        assert (this.outForwarder.outputOwner != null);
        assert (this.errForwarder.outputOwner != null);
        this.redirector.redirectStandardOutputTo(this.outForwarder);
        this.redirector.redirectStandardErrorTo(this.errForwarder);
        this.redirector.start();
    }

    public void stopRedirecting() {
        this.redirector.stop();
    }

    public void setOutputOwner(Object testId) {
        assert (testId != null);
        if (System.out != null) {
            System.out.flush();
        }
        if (System.err != null) {
            System.err.flush();
        }
        this.outForwarder.outputOwner = testId;
        this.errForwarder.outputOwner = testId;
    }

    static class Forwarder
    implements StandardOutputRedirector.OutputListener {
        final Clock clock;
        final TestResultProcessor processor;
        final TestOutputEvent.Destination dest;
        Object outputOwner;

        public Forwarder(Clock clock, TestResultProcessor processor, TestOutputEvent.Destination dest) {
            this.clock = clock;
            this.processor = processor;
            this.dest = dest;
        }

        @Override
        public void onOutput(CharSequence output) {
            if (this.outputOwner == null) {
                throw new RuntimeException("Unable send output event from test executor. Please report this problem. Destination: " + (Object)((Object)this.dest) + ", event: " + output.toString());
            }
            this.processor.output(this.outputOwner, new DefaultTestOutputEvent(this.clock.getCurrentTime(), this.dest, output.toString()));
        }
    }
}

