/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import org.jsampler.Server;
import org.jsampler.ServerList;
import org.jsampler.view.ServerTableModel;

public class ServerTable
extends JTable {
    public ServerTable() {
        this(new ServerTableModel(new ServerList()));
    }

    public ServerTable(ServerTableModel serverTableModel) {
        super(serverTableModel);
        this.setSelectionMode(0);
        this.installKeyboardListeners();
    }

    private void installKeyboardListeners() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 9);
        this.getInputMap(0).put(keyStroke, "moveServerOnTop");
        this.getActionMap().put("moveServerOnTop", new Actions("moveServerOnTop"));
        keyStroke = KeyStroke.getKeyStroke(38, 8);
        this.getInputMap(0).put(keyStroke, "moveServerUp");
        this.getActionMap().put("moveServerUp", new Actions("moveServerUp"));
        keyStroke = KeyStroke.getKeyStroke(40, 8);
        this.getInputMap(0).put(keyStroke, "moveServerDown");
        this.getActionMap().put("moveServerDown", new Actions("moveServerDown"));
        keyStroke = KeyStroke.getKeyStroke(40, 9);
        this.getInputMap(0).put(keyStroke, "moveServerAtBottom");
        this.getActionMap().put("moveServerAtBottom", new Actions("moveServerAtBottom"));
    }

    @Override
    public ServerTableModel getModel() {
        return (ServerTableModel)super.getModel();
    }

    public Server getSelectedServer() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return this.getModel().getServerAt(n);
    }

    public void setSelectedServer(Server server) {
        int n = this.getModel().getServerList().getServerIndex(server);
        if (n == -1) {
            return;
        }
        this.getSelectionModel().setSelectionInterval(n, n);
    }

    public void moveSelectedServerUp() {
        int n = this.getSelectedRow();
        if (n < 1) {
            return;
        }
        Server server = this.getSelectedServer();
        this.getModel().getServerList().moveServerUp(server);
        this.setSelectedServer(server);
    }

    public void moveSelectedServerDown() {
        int n = this.getSelectedRow();
        if (n == -1 || n == this.getModel().getRowCount() - 1) {
            return;
        }
        Server server = this.getSelectedServer();
        this.getModel().getServerList().moveServerDown(server);
        this.setSelectedServer(server);
    }

    public void removeSelectedServer() {
        Server server = this.getSelectedServer();
        if (server == null) {
            return;
        }
        int n = this.getSelectedRow();
        this.getModel().getServerList().removeServer(server);
        if (this.getRowCount() > n) {
            this.getSelectionModel().setSelectionInterval(n, n);
        } else {
            n = this.getRowCount() - 1;
            if (n >= 0) {
                this.getSelectionModel().setSelectionInterval(n, n);
            }
        }
    }

    private class Actions
    extends AbstractAction {
        private static final String MOVE_ON_TOP = "moveServerOnTop";
        private static final String MOVE_UP = "moveServerUp";
        private static final String MOVE_DOWN = "moveServerDown";
        private static final String MOVE_AT_BOTTOM = "moveServerAtBottom";

        Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getValue("Name").toString();
            if (string == MOVE_ON_TOP) {
                Server server = ServerTable.this.getSelectedServer();
                ServerTable.this.getModel().getServerList().moveServerOnTop(server);
                ServerTable.this.setSelectedServer(server);
            } else if (string == MOVE_UP) {
                ServerTable.this.moveSelectedServerUp();
            } else if (string == MOVE_DOWN) {
                ServerTable.this.moveSelectedServerDown();
            } else if (string == MOVE_AT_BOTTOM) {
                Server server = ServerTable.this.getSelectedServer();
                ServerTable.this.getModel().getServerList().moveServerAtBottom(server);
                ServerTable.this.setSelectedServer(server);
            }
        }
    }
}

