/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.panache.common.deployment;

import java.util.Map;
import org.jboss.jandex.ClassType;
import org.jboss.jandex.DotName;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class ByteCodeType {
    private static final Map<String, Type> WRAPPER_TO_PRIMITIVE = Map.of(Boolean.class.getName(), PrimitiveType.BOOLEAN, Byte.class.getName(), PrimitiveType.BYTE, Short.class.getName(), PrimitiveType.SHORT, Integer.class.getName(), PrimitiveType.INT, Long.class.getName(), PrimitiveType.LONG, Float.class.getName(), PrimitiveType.FLOAT, Double.class.getName(), PrimitiveType.DOUBLE, Character.class.getName(), PrimitiveType.CHAR);
    private final Type type;

    public ByteCodeType(Class<?> type) {
        this.type = ClassType.create((DotName)DotName.createSimple((String)type.getName()));
    }

    public ByteCodeType(Type type) {
        this.type = type;
    }

    public Type get() {
        return this.type;
    }

    public String descriptor() {
        return this.type.descriptor();
    }

    public DotName dotName() {
        return this.type.name();
    }

    public String internalName() {
        return this.type.name().toString('/');
    }

    public boolean isPrimitive() {
        return this.type.kind() == Type.Kind.PRIMITIVE;
    }

    public String toString() {
        return ByteCodeType.class.getSimpleName() + "[" + String.valueOf(this.type) + "]";
    }

    public org.objectweb.asm.Type type() {
        return org.objectweb.asm.Type.getType((String)this.type.descriptor());
    }

    public ByteCodeType unbox() {
        return new ByteCodeType(WRAPPER_TO_PRIMITIVE.getOrDefault(this.type.name().toString(), this.type));
    }
}

