/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.snapshotmanagement.api.resthandler;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.SMActions;
import org.opensearch.indexmanagement.snapshotmanagement.api.transport.explain.ExplainSMPolicyRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0016J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/indexmanagement/snapshotmanagement/api/resthandler/RestExplainSMPolicyHandler;", "Lorg/opensearch/rest/BaseRestHandler;", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getName", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "opensearch-index-management"})
public final class RestExplainSMPolicyHandler
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestExplainSMPolicyHandler.class);

    @NotNull
    public String getName() {
        return "snapshot_management_explain_policy_rest_handler";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.listOf((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/{policyName}/_explain"));
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Ref.ObjectRef policyNames = new Ref.ObjectRef();
        String[] stringArray = Strings.splitStringByCommaToArray((String)request.param("policyName", ""));
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitStringByCommaToArray(...)");
        policyNames.element = stringArray;
        if (((Object[])policyNames.element).length == 0) {
            String[] stringArray2 = new String[]{"*"};
            policyNames.element = stringArray2;
        }
        this.log.debug("Explain snapshot management policy request received with policy name(s) [" + policyNames.element + "]");
        return arg_0 -> RestExplainSMPolicyHandler.prepareRequest$lambda$0(client, policyNames, arg_0);
    }

    private static final void prepareRequest$lambda$0(NodeClient $client, Ref.ObjectRef $policyNames, RestChannel it) {
        $client.execute(SMActions.INSTANCE.getEXPLAIN_SM_POLICY_ACTION_TYPE(), (ActionRequest)new ExplainSMPolicyRequest((String[])$policyNames.element), (ActionListener)new RestToXContentListener(it));
    }
}

