/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.common;

import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Objects;
import net.schmizz.sshj.common.SecurityUtils;

public class Ed25519KeyFactory {
    private static final int KEY_LENGTH = 32;
    private static final String KEY_ALGORITHM = "Ed25519";
    private static final byte[] ED25519_PKCS8_PRIVATE_KEY_HEADER = Base64.getDecoder().decode("MC4CAQEwBQYDK2VwBCIEIA");
    private static final byte[] ED25519_PKCS8_PUBLIC_KEY_HEADER = Base64.getDecoder().decode("MCowBQYDK2VwAyEA");
    private static final int PRIVATE_KEY_ENCODED_LENGTH = 48;
    private static final int PUBLIC_KEY_ENCODED_LENGTH = 44;

    private Ed25519KeyFactory() {
    }

    public static PrivateKey getPrivateKey(byte[] privateKeyBinary) throws GeneralSecurityException {
        Objects.requireNonNull(privateKeyBinary, "Private Key byte array required");
        if (privateKeyBinary.length == 32) {
            byte[] privateKeyEncoded = new byte[48];
            System.arraycopy(ED25519_PKCS8_PRIVATE_KEY_HEADER, 0, privateKeyEncoded, 0, ED25519_PKCS8_PRIVATE_KEY_HEADER.length);
            System.arraycopy(privateKeyBinary, 0, privateKeyEncoded, ED25519_PKCS8_PRIVATE_KEY_HEADER.length, 32);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyEncoded);
            KeyFactory keyFactory = SecurityUtils.getKeyFactory(KEY_ALGORITHM);
            return keyFactory.generatePrivate(keySpec);
        }
        throw new IllegalArgumentException("Key length of 32 bytes required");
    }

    public static PublicKey getPublicKey(byte[] publicKeyBinary) throws GeneralSecurityException {
        Objects.requireNonNull(publicKeyBinary, "Public Key byte array required");
        if (publicKeyBinary.length == 32) {
            byte[] publicKeyEncoded = new byte[44];
            System.arraycopy(ED25519_PKCS8_PUBLIC_KEY_HEADER, 0, publicKeyEncoded, 0, ED25519_PKCS8_PUBLIC_KEY_HEADER.length);
            System.arraycopy(publicKeyBinary, 0, publicKeyEncoded, ED25519_PKCS8_PUBLIC_KEY_HEADER.length, 32);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyEncoded);
            KeyFactory keyFactory = SecurityUtils.getKeyFactory(KEY_ALGORITHM);
            return keyFactory.generatePublic(keySpec);
        }
        throw new IllegalArgumentException("Key length of 32 bytes required");
    }
}

