/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.loader.batik;

import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.util.DOMUtilities;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public final class BatikUtil {
    private BatikUtil() {
    }

    public static boolean isBatikAvailable() {
        try {
            Class.forName("org.apache.batik.anim.dom.SVGDOMImplementation");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Document cloneSVGDocument(Document doc) {
        Document clonedDoc;
        DOMImplementation impl = doc.getImplementation();
        if (!(impl instanceof SVGDOMImplementation)) {
            impl = new SVGDOMImplementation();
        }
        if ((clonedDoc = DOMUtilities.deepCloneDocument((Document)doc, (DOMImplementation)impl)) instanceof AbstractDocument) {
            clonedDoc.setDocumentURI(doc.getDocumentURI());
        }
        return clonedDoc;
    }
}

