/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.TaskExecutionRequest;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.provider.ConfigurationTimeBarrier;
import org.gradle.execution.BuildWorkExecutor;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.TaskInAnotherBuild;
import org.gradle.execution.plan.TaskNode;
import org.gradle.internal.build.ExecutionResult;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.util.internal.IncubationLogger;

public class TaskGraphBuildExecutionAction
implements BuildWorkExecutor {
    private final BuildWorkExecutor delegate;
    private final StyledTextOutputFactory textOutputFactory;
    private final ConfigurationTimeBarrier configurationTimeBarrier;

    public TaskGraphBuildExecutionAction(BuildWorkExecutor delegate, StyledTextOutputFactory textOutputFactory, ConfigurationTimeBarrier configurationTimeBarrier) {
        this.delegate = delegate;
        this.textOutputFactory = textOutputFactory;
        this.configurationTimeBarrier = configurationTimeBarrier;
    }

    @Override
    public ExecutionResult<Void> execute(GradleInternal gradle, FinalizedExecutionPlan plan) {
        if (this.configurationTimeBarrier.isAtConfigurationTime()) {
            return this.delegate.execute(gradle, plan);
        }
        if (gradle.isRootBuild()) {
            IncubationLogger.incubatingFeatureUsed((String)"Task graph printing");
            this.renderTaskGraph(gradle, plan);
        }
        return ExecutionResult.succeeded();
    }

    private void renderTaskGraph(GradleInternal gradle, FinalizedExecutionPlan plan) {
        plan.getContents().getScheduledNodes().visitNodes((nodes, entryNodes) -> {
            String invocation = TaskGraphBuildExecutionAction.renderRequestedTasks(gradle.getStartParameter());
            StyledTextOutput output = this.textOutputFactory.create(TaskGraphBuildExecutionAction.class);
            DirectedGraphRenderer<TaskInfo> renderer = new DirectedGraphRenderer<TaskInfo>(new NodeRenderer(), new NodesGraph());
            renderer.renderTo((TaskInfo)new RootNode((Collection<Node>)entryNodes, invocation), output);
        });
    }

    private static String renderRequestedTasks(StartParameterInternal startParameter) {
        return startParameter.getTaskRequests().stream().map(TaskExecutionRequest::getArgs).flatMap(Collection::stream).collect(Collectors.joining(" "));
    }

    private static Stream<TaskInfo> extractTaskNodes(Collection<Node> collection, DependencyType type) {
        return collection.stream().filter(node -> node instanceof TaskNode && !node.isDoNotIncludeInPlan()).map(taskNode -> new DefaultTaskInfo((TaskNode)taskNode, type));
    }

    private static enum DependencyType {
        REGULAR,
        FINALIZING;

    }

    private static class DefaultTaskInfo
    implements TaskInfo {
        private final TaskNode node;
        private final DependencyType type;

        DefaultTaskInfo(TaskNode node, DependencyType type) {
            this.node = node;
            this.type = type;
        }

        @Override
        public String getId() {
            return this.node.toString();
        }

        @Override
        public String getDescription() {
            StringBuilder description = new StringBuilder();
            description.append("(");
            description.append(this.node.getTask().getTaskIdentity().getTaskType().getCanonicalName());
            if (this.type.equals((Object)DependencyType.FINALIZING)) {
                description.append(", finalizer");
            }
            if (!this.node.getTask().getEnabled()) {
                description.append(", disabled");
            }
            description.append(")");
            return description.toString();
        }

        @Override
        public Collection<TaskInfo> getDependencies() {
            TaskNode targetNode = this.node;
            if (this.node instanceof TaskInAnotherBuild) {
                targetNode = ((TaskInAnotherBuild)this.node).getTargetNode();
            }
            return Streams.concat((Stream[])new Stream[]{TaskGraphBuildExecutionAction.extractTaskNodes(targetNode.getDependencySuccessors(), DependencyType.REGULAR), TaskGraphBuildExecutionAction.extractTaskNodes(targetNode.getFinalizers(), DependencyType.FINALIZING)}).collect(Collectors.toList());
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultTaskInfo that = (DefaultTaskInfo)o;
            return this.node.equals(that.node);
        }
    }

    private static class NodeRenderer
    implements GraphNodeRenderer<TaskInfo> {
        private NodeRenderer() {
        }

        @Override
        public void renderTo(TaskInfo node, StyledTextOutput output, boolean alreadySeen) {
            String description;
            output.withStyle(StyledTextOutput.Style.Identifier).text((Object)node.getId());
            if (!alreadySeen && !(description = node.getDescription()).isEmpty()) {
                output.text((Object)" ");
                output.withStyle(StyledTextOutput.Style.Description).text((Object)description);
            }
        }
    }

    private static class NodesGraph
    implements DirectedGraph<TaskInfo, TaskInfo> {
        private NodesGraph() {
        }

        public void getNodeValues(TaskInfo node, Collection<? super TaskInfo> values, Collection<? super TaskInfo> connectedNodes) {
            values.add(node);
            connectedNodes.addAll(node.getDependencies());
        }
    }

    private static class RootNode
    implements TaskInfo {
        private final Collection<Node> entryNodes;
        private final String invocationInfo;

        public RootNode(Collection<Node> entryNodes, String invocationInfo) {
            this.entryNodes = entryNodes;
            this.invocationInfo = invocationInfo;
        }

        @Override
        public String getId() {
            return "Tasks graph for: " + this.invocationInfo;
        }

        @Override
        public String getDescription() {
            return "";
        }

        @Override
        public Collection<TaskInfo> getDependencies() {
            return TaskGraphBuildExecutionAction.extractTaskNodes(this.entryNodes, DependencyType.REGULAR).collect(Collectors.toList());
        }
    }

    private static interface TaskInfo {
        public String getId();

        public String getDescription();

        public Collection<TaskInfo> getDependencies();
    }
}

