/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI;

import com.intellij.debugger.mockJDI.MockMirror;
import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.List;

public class MockLocation
extends MockMirror
implements Location {
    private final int myLineNumber;
    private final String mySourcePath;
    private final String mySourceName;
    private final long myCodeIndex;
    private final Method myMethod;

    public MockLocation(int lineNumber, long codeIndex, Method method, String sourcePath, String sourceName) {
        super((MockVirtualMachine)method.virtualMachine());
        this.mySourceName = sourceName;
        this.mySourcePath = sourcePath;
        this.myLineNumber = lineNumber;
        this.myCodeIndex = codeIndex;
        this.myMethod = method;
    }

    public MockLocation(int lineNumber, long codeIndex, Method method) {
        super((MockVirtualMachine)method.virtualMachine());
        this.myLineNumber = lineNumber;
        this.myCodeIndex = codeIndex;
        this.myMethod = method;
        try {
            List<String> paths = this.declaringType().sourcePaths("");
            this.mySourcePath = paths.isEmpty() ? null : paths.get(0);
            this.mySourceName = this.declaringType().sourceName();
        }
        catch (AbsentInformationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int lineNumber(String string) {
        return this.myLineNumber;
    }

    @Override
    public int lineNumber() {
        return this.myLineNumber;
    }

    @Override
    public String sourcePath(String string) {
        return this.mySourcePath;
    }

    @Override
    public String sourcePath() {
        return this.mySourcePath;
    }

    @Override
    public String sourceName(String string) {
        return this.mySourceName;
    }

    @Override
    public String sourceName() {
        return this.mySourceName;
    }

    @Override
    public long codeIndex() {
        return this.myCodeIndex;
    }

    @Override
    public Method method() {
        return this.myMethod;
    }

    @Override
    public ReferenceType declaringType() {
        return this.method().declaringType();
    }

    @Override
    public int compareTo(Location o) {
        long codeIndex = ((MockLocation)o).myCodeIndex;
        return Long.compare(this.myCodeIndex, codeIndex);
    }
}

