/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import org.hibernate.MappingException;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.Resolvable;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SortableValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ValueVisitor;
import org.hibernate.type.Type;

public class DependantValue
extends SimpleValue
implements Resolvable,
SortableValue {
    private final KeyValue wrappedValue;
    private boolean nullable;
    private boolean updateable;
    private boolean sorted;

    public DependantValue(MetadataBuildingContext buildingContext, Table table, KeyValue prototype) {
        super(buildingContext, table);
        this.wrappedValue = prototype;
    }

    private DependantValue(DependantValue original) {
        super(original);
        this.wrappedValue = (KeyValue)original.wrappedValue.copy();
        this.nullable = original.nullable;
        this.updateable = original.updateable;
        this.sorted = original.sorted;
    }

    @Override
    public DependantValue copy() {
        return new DependantValue(this);
    }

    public KeyValue getWrappedValue() {
        return this.wrappedValue;
    }

    @Override
    public Type getType() throws MappingException {
        return this.wrappedValue.getType();
    }

    @Override
    public void setTypeUsingReflection(String className, String propertyName) {
    }

    @Override
    public Object accept(ValueVisitor visitor) {
        return visitor.accept(this);
    }

    @Override
    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Override
    public boolean isUpdateable() {
        return this.updateable;
    }

    public void setUpdateable(boolean updateable) {
        this.updateable = updateable;
    }

    @Override
    public boolean isSame(SimpleValue other) {
        DependantValue dependantValue;
        return other instanceof DependantValue && this.isSame(dependantValue = (DependantValue)other);
    }

    public boolean isSame(DependantValue other) {
        return super.isSame(other) && DependantValue.isSame(this.wrappedValue, other.wrappedValue);
    }

    @Override
    public boolean resolve(MetadataBuildingContext buildingContext) {
        this.resolve();
        return true;
    }

    @Override
    public BasicValue.Resolution<?> resolve() {
        KeyValue keyValue = this.wrappedValue;
        if (keyValue instanceof BasicValue) {
            BasicValue basicValue = (BasicValue)keyValue;
            return basicValue.resolve();
        }
        throw new UnsupportedOperationException("Trying to resolve the wrapped value but it is non a BasicValue");
    }

    @Override
    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    @Override
    public int[] sortProperties() {
        if (!this.sorted) {
            SortableValue sortableValue;
            int[] originalOrder;
            this.sorted = true;
            KeyValue keyValue = this.wrappedValue;
            if (keyValue instanceof SortableValue && (originalOrder = (sortableValue = (SortableValue)((Object)keyValue)).sortProperties()) != null) {
                this.sortColumns(originalOrder);
            }
        }
        return null;
    }
}

