/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.extract.internal;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.hibernate.boot.model.naming.DatabaseIdentifier;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.dialect.Dialect;
import org.hibernate.tool.schema.extract.internal.AbstractInformationExtractorImpl;
import org.hibernate.tool.schema.extract.internal.ColumnInformationImpl;
import org.hibernate.tool.schema.extract.spi.ExtractionContext;
import org.hibernate.tool.schema.extract.spi.TableInformation;

public class InformationExtractorJdbcDatabaseMetaDataImpl
extends AbstractInformationExtractorImpl {
    public InformationExtractorJdbcDatabaseMetaDataImpl(ExtractionContext extractionContext) {
        super(extractionContext);
    }

    private DatabaseMetaData getJdbcDatabaseMetaData() {
        return this.getExtractionContext().getJdbcDatabaseMetaData();
    }

    @Override
    protected String getResultSetTableTypesPhysicalTableConstant() {
        return "TABLE";
    }

    @Override
    public <T> T processCatalogsResultSet(ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getCatalogs();){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processSchemaResultSet(String catalog, String schemaPattern, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getSchemas(catalog, schemaPattern);){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processTableResultSet(String catalog, String schemaPattern, String tableNamePattern, String[] types, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getTables(catalog, schemaPattern, tableNamePattern, types);){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processColumnsResultSet(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processPrimaryKeysResultSet(String catalogFilter, String schemaFilter, Identifier tableName, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getPrimaryKeys(catalogFilter, schemaFilter, tableName.getText());){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processIndexInfoResultSet(String catalog, String schema, String table, boolean unique, boolean approximate, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getIndexInfo(catalog, schema, table, unique, approximate);){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processImportedKeysResultSet(String catalog, String schema, String table, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getImportedKeys(catalog, schema, table);){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected <T> T processCrossReferenceResultSet(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable, ExtractionContext.ResultSetProcessor<T> processor) throws SQLException {
        try (ResultSet resultSet = this.getJdbcDatabaseMetaData().getCrossReference(parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);){
            T t = processor.process(resultSet);
            return t;
        }
    }

    @Override
    protected void addColumns(TableInformation tableInformation) {
        Dialect dialect = this.getJdbcEnvironment().getDialect();
        ExtractionContext extractionContext = this.getExtractionContext();
        QualifiedTableName qualifiedTableName = tableInformation.getName();
        String tableName = extractionContext.getSqlStringGenerationContext().format(qualifiedTableName.quote());
        try {
            extractionContext.getQueryResults("select * from " + tableName + " where 1=0", null, resultSet -> {
                ResultSetMetaData metaData = resultSet.getMetaData();
                int columnCount = metaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    tableInformation.addColumn(InformationExtractorJdbcDatabaseMetaDataImpl.columnInformation(tableInformation, metaData, i, dialect));
                }
                return null;
            });
        }
        catch (SQLException e) {
            throw this.convertSQLException(e, "Error accessing column metadata: " + String.valueOf(qualifiedTableName));
        }
    }

    private static Boolean interpretNullable(int nullable) {
        return switch (nullable) {
            case 1 -> Boolean.TRUE;
            case 0 -> Boolean.FALSE;
            default -> null;
        };
    }

    private static ColumnInformationImpl columnInformation(TableInformation tableInformation, ResultSetMetaData metaData, int i, Dialect dialect) throws SQLException {
        String columnName = metaData.getColumnName(i);
        int columnType = metaData.getColumnType(i);
        String typeName = new StringTokenizer(metaData.getColumnTypeName(i), "()").nextToken();
        int scale = metaData.getScale(i);
        return new ColumnInformationImpl(tableInformation, DatabaseIdentifier.toIdentifier(columnName), columnType, typeName, dialect.resolveSqlTypeLength(typeName, columnType, metaData.getPrecision(i), scale, metaData.getColumnDisplaySize(i)), scale, InformationExtractorJdbcDatabaseMetaDataImpl.interpretNullable(metaData.isNullable(i)));
    }
}

