/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal.dynamic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Locale;
import org.hibernate.models.IllegalCastException;
import org.hibernate.models.ModelsException;
import org.hibernate.models.internal.dynamic.AbstractAnnotationTarget;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassLoading;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.MutableClassDetails;
import org.hibernate.models.spi.MutableMemberDetails;
import org.hibernate.models.spi.RecordComponentDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableScope;

public class DynamicFieldDetails
extends AbstractAnnotationTarget
implements FieldDetails,
MutableMemberDetails {
    private final String name;
    private final TypeDetails type;
    private final ClassDetails declaringType;
    private final int modifierFlags;
    private final boolean isArray;
    private final boolean isPlural;
    private Field field;

    public DynamicFieldDetails(String name, TypeDetails type, ClassDetails declaringType, int modifierFlags, boolean isArray, boolean isPlural, ModelsContext modelsContext) {
        super(modelsContext);
        this.name = name;
        this.type = type;
        this.declaringType = declaringType;
        this.modifierFlags = modifierFlags;
        this.isArray = isArray;
        this.isPlural = isPlural;
        assert (this.isPersistable());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeDetails getType() {
        return this.type;
    }

    @Override
    public ClassDetails getDeclaringType() {
        return this.declaringType;
    }

    @Override
    public boolean isPlural() {
        return this.isPlural;
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public int getModifiers() {
        return this.modifierFlags;
    }

    @Override
    public Field toJavaMember() {
        if (this.field == null && this.getDeclaringType().getClassName() != null) {
            Class declaringClass = this.getDeclaringType().toJavaClass();
            this.field = this.toJavaMember(declaringClass, this.getModelContext().getClassLoading(), this.getModelContext());
        }
        return this.field;
    }

    @Override
    public Field toJavaMember(Class<?> declaringClass, ClassLoading classLoading, ModelsContext modelContext) {
        try {
            this.type.determineRawClass().toJavaClass(classLoading, modelContext);
            return declaringClass.getDeclaredField(this.getName());
        }
        catch (NoSuchFieldException e) {
            throw new ModelsException(String.format(Locale.ROOT, "Unable to locate field `%s` on %s", this.getName(), declaringClass.getName()), e);
        }
    }

    @Override
    public TypeDetails resolveRelativeType(TypeVariableScope container) {
        return this.type;
    }

    public String toString() {
        return "DynamicFieldDetails(" + this.name + ")";
    }

    @Override
    public FieldDetails asFieldDetails() {
        return this;
    }

    @Override
    public MutableMemberDetails asMemberDetails() {
        return this;
    }

    @Override
    public MethodDetails asMethodDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as MethodDetails");
    }

    @Override
    public RecordComponentDetails asRecordComponentDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as RecordComponentDetails");
    }

    @Override
    public MutableClassDetails asClassDetails() {
        throw new IllegalCastException("FieldDetails cannot be cast as ClassDetails");
    }

    @Override
    public <A extends Annotation> AnnotationDescriptor<A> asAnnotationDescriptor() {
        throw new IllegalCastException("FieldDetails cannot be cast as AnnotationDescriptor");
    }
}

