/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.rar.model;

import java.util.Objects;
import org.keycloak.models.ClientScopeModel;

public class IntermediaryScopeRepresentation {
    private final ClientScopeModel scope;
    private final String requestedScopeString;
    private final String parameter;
    private final boolean isDynamic;

    public IntermediaryScopeRepresentation(ClientScopeModel scope, String parameter, String requestedScopeString) {
        this.scope = scope;
        this.parameter = parameter;
        this.isDynamic = scope.isDynamicScope();
        this.requestedScopeString = requestedScopeString;
    }

    public IntermediaryScopeRepresentation(ClientScopeModel scope) {
        this.scope = scope;
        this.isDynamic = false;
        this.parameter = null;
        this.requestedScopeString = scope.getName();
    }

    public ClientScopeModel getScope() {
        return this.scope;
    }

    public String getParameter() {
        return this.parameter;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public String getRequestedScopeString() {
        return this.requestedScopeString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntermediaryScopeRepresentation that = (IntermediaryScopeRepresentation)o;
        return this.isDynamic == that.isDynamic && Objects.equals(this.scope.getName(), that.scope.getName()) && Objects.equals(this.parameter, that.parameter);
    }

    public int hashCode() {
        return Objects.hash(this.scope.getName(), this.parameter, this.isDynamic);
    }
}

