/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.netty.runtime.virtual;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.AbstractServerChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.PreferHeapByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.util.concurrent.SingleThreadEventExecutor;
import io.quarkus.netty.runtime.virtual.VirtualAddress;
import io.quarkus.netty.runtime.virtual.VirtualChannel;
import io.quarkus.netty.runtime.virtual.VirtualChannelRegistry;
import io.quarkus.netty.runtime.virtual.VirtualClientConnection;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;

public class VirtualServerChannel
extends AbstractServerChannel {
    private final ChannelConfig config = new DefaultChannelConfig((Channel)this);
    private final Queue<Object> inboundBuffer = new ArrayDeque<Object>();
    private final Runnable shutdownHook = new Runnable(){

        @Override
        public void run() {
            VirtualServerChannel.this.unsafe().close(VirtualServerChannel.this.unsafe().voidPromise());
        }
    };
    private volatile int state;
    private volatile VirtualAddress localAddress;
    private volatile boolean acceptInProgress;

    public VirtualServerChannel() {
        this.config().setAllocator((ByteBufAllocator)new PreferHeapByteBufAllocator(this.config.getAllocator()));
    }

    public ChannelConfig config() {
        return this.config;
    }

    public VirtualAddress localAddress() {
        return (VirtualAddress)super.localAddress();
    }

    public VirtualAddress remoteAddress() {
        return (VirtualAddress)super.remoteAddress();
    }

    public boolean isOpen() {
        return this.state < 2;
    }

    public boolean isActive() {
        return this.state == 1;
    }

    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof SingleThreadEventLoop;
    }

    protected SocketAddress localAddress0() {
        return this.localAddress;
    }

    protected void doRegister() throws Exception {
        ((SingleThreadEventExecutor)this.eventLoop()).addShutdownHook(this.shutdownHook);
    }

    protected void doBind(SocketAddress localAddress) throws Exception {
        this.localAddress = VirtualChannelRegistry.register((Channel)this, this.localAddress, localAddress);
        this.state = 1;
    }

    protected void doClose() throws Exception {
        if (this.state <= 1) {
            if (this.localAddress != null) {
                VirtualChannelRegistry.unregister(this.localAddress);
                this.localAddress = null;
            }
            this.state = 2;
        }
    }

    protected void doDeregister() throws Exception {
        ((SingleThreadEventExecutor)this.eventLoop()).removeShutdownHook(this.shutdownHook);
    }

    protected void doBeginRead() throws Exception {
        if (this.acceptInProgress) {
            return;
        }
        Queue<Object> inboundBuffer = this.inboundBuffer;
        if (inboundBuffer.isEmpty()) {
            this.acceptInProgress = true;
            return;
        }
        this.readInbound();
    }

    VirtualChannel serve(VirtualClientConnection peer) {
        final VirtualChannel child = this.newLocalChannel(peer);
        if (this.eventLoop().inEventLoop()) {
            this.serve0(child);
        } else {
            this.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    VirtualServerChannel.this.serve0(child);
                }
            });
        }
        return child;
    }

    private void readInbound() {
        Object m;
        RecvByteBufAllocator.Handle handle = this.unsafe().recvBufAllocHandle();
        handle.reset(this.config());
        ChannelPipeline pipeline = this.pipeline();
        while ((m = this.inboundBuffer.poll()) != null) {
            pipeline.fireChannelRead(m);
            if (handle.continueReading()) continue;
        }
        pipeline.fireChannelReadComplete();
    }

    protected VirtualChannel newLocalChannel(VirtualClientConnection peer) {
        return new VirtualChannel(this, peer);
    }

    private void serve0(VirtualChannel child) {
        this.inboundBuffer.add((Object)child);
        if (this.acceptInProgress) {
            this.acceptInProgress = false;
            this.readInbound();
        }
    }
}

