/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openapitools.openapidiff.core.model.BackwardIncompatibleProp;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedParameter;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public class ChangedParameters
implements ComposedChanged {
    private final List<Parameter> oldParameterList;
    private final List<Parameter> newParameterList;
    private final DiffContext context;
    private List<Parameter> increased;
    private List<Parameter> missing;
    private List<ChangedParameter> changed;

    public ChangedParameters(List<Parameter> oldParameterList, List<Parameter> newParameterList, DiffContext context) {
        this.oldParameterList = oldParameterList;
        this.newParameterList = newParameterList;
        this.context = context;
        this.increased = new ArrayList<Parameter>();
        this.missing = new ArrayList<Parameter>();
        this.changed = new ArrayList<ChangedParameter>();
    }

    @Override
    public List<Changed> getChangedElements() {
        return new ArrayList<Changed>(this.changed);
    }

    @Override
    public DiffResult isCoreChanged() {
        if (this.increased.isEmpty() && this.missing.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        if (!this.missing.isEmpty() && BackwardIncompatibleProp.REQUEST_PARAMS_DECREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        if (this.increased.stream().anyMatch(p -> p.getRequired() != null && p.getRequired() != false) && BackwardIncompatibleProp.REQUEST_PARAMS_REQUIRED_INCREASED.enabled(this.context, new Object[0])) {
            return DiffResult.INCOMPATIBLE;
        }
        return DiffResult.COMPATIBLE;
    }

    public List<Parameter> getOldParameterList() {
        return this.oldParameterList;
    }

    public List<Parameter> getNewParameterList() {
        return this.newParameterList;
    }

    public DiffContext getContext() {
        return this.context;
    }

    public List<Parameter> getIncreased() {
        return this.increased;
    }

    public List<Parameter> getMissing() {
        return this.missing;
    }

    public List<ChangedParameter> getChanged() {
        return this.changed;
    }

    public ChangedParameters setIncreased(List<Parameter> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedParameters setMissing(List<Parameter> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedParameters setChanged(List<ChangedParameter> changed) {
        this.changed = changed;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedParameters that = (ChangedParameters)o;
        return Objects.equals(this.oldParameterList, that.oldParameterList) && Objects.equals(this.newParameterList, that.newParameterList) && Objects.equals(this.context, that.context) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.changed, that.changed);
    }

    public int hashCode() {
        return Objects.hash(this.oldParameterList, this.newParameterList, this.context, this.increased, this.missing, this.changed);
    }

    public String toString() {
        return "ChangedParameters(oldParameterList=" + this.getOldParameterList() + ", newParameterList=" + this.getNewParameterList() + ", context=" + this.getContext() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", changed=" + this.getChanged() + ")";
    }
}

