/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.geospatial.action.upload.geojson;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.action.bulk.BulkRequestBuilder;
import org.opensearch.action.index.IndexRequestBuilder;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.core.common.Strings;
import org.opensearch.geospatial.GeospatialParser;
import org.opensearch.geospatial.action.upload.geojson.UploadGeoJSONRequestContent;
import org.opensearch.transport.client.Client;

public class ContentBuilder {
    public static final String GEOJSON_FEATURE_ID_FIELD = "id";
    private final Client client;

    public ContentBuilder(Client client) {
        this.client = Objects.requireNonNull(client, "Client cannot be null");
    }

    public Optional<BulkRequestBuilder> prepare(UploadGeoJSONRequestContent content, String pipeline) {
        return this.prepareContentRequest(content, pipeline);
    }

    private Optional<BulkRequestBuilder> prepareContentRequest(UploadGeoJSONRequestContent content, String pipeline) {
        if (content.getData().isEmpty()) {
            return Optional.empty();
        }
        BulkRequestBuilder builder = this.prepareBulkRequestBuilder();
        content.getData().stream().map(GeospatialParser::toStringObjectMap).map(GeospatialParser::getFeatures).flatMap(Collection::stream).map(this::createIndexRequestBuilder).map(indexRequestBuilder -> (IndexRequestBuilder)indexRequestBuilder.setIndex(content.getIndexName())).map(indexRequestBuilder -> indexRequestBuilder.setPipeline(pipeline)).forEach(arg_0 -> ((BulkRequestBuilder)builder).add(arg_0));
        if (builder.numberOfActions() < 1) {
            return Optional.empty();
        }
        return Optional.of(builder);
    }

    private BulkRequestBuilder prepareBulkRequestBuilder() {
        return (BulkRequestBuilder)this.client.prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
    }

    private IndexRequestBuilder createIndexRequestBuilder(Map<String, Object> source) {
        IndexRequestBuilder requestBuilder = this.client.prepareIndex().setSource(source);
        String id = GeospatialParser.extractValueAsString(source, GEOJSON_FEATURE_ID_FIELD);
        return Strings.hasText((String)id) ? requestBuilder.setId(id) : requestBuilder;
    }
}

