/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.mrtree.intermediate;

import java.util.ArrayList;
import org.eclipse.elk.alg.mrtree.graph.TGraph;
import org.eclipse.elk.alg.mrtree.graph.TNode;
import org.eclipse.elk.alg.mrtree.options.InternalProperties;
import org.eclipse.elk.alg.mrtree.options.MrTreeOptions;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.Pair;

public class LevelCoordinatesProcessor
implements ILayoutProcessor<TGraph> {
    @Override
    public void process(TGraph tGraph, IElkProgressMonitor progressMonitor) {
        int curLevel;
        progressMonitor.begin("Processor determine the coords for each level", 1.0f);
        ArrayList<Pair<Double, Double>> levels = new ArrayList<Pair<Double, Double>>();
        for (TNode n : tGraph.getNodes()) {
            while (n.getProperty(MrTreeOptions.TREE_LEVEL) > levels.size() - 1) {
                levels.add(new Pair<Double, Double>((Double)Double.MAX_VALUE, -1.7976931348623157E308));
            }
            curLevel = n.getProperty(MrTreeOptions.TREE_LEVEL);
            if (tGraph.getProperty(MrTreeOptions.DIRECTION).isHorizontal()) {
                if (n.getPosition().x < (Double)((Pair)levels.get(curLevel)).getFirst()) {
                    ((Pair)levels.get(curLevel)).setFirst(n.getPosition().x);
                }
                if (!(n.getPosition().x + n.getSize().x > (Double)((Pair)levels.get(curLevel)).getSecond())) continue;
                ((Pair)levels.get(curLevel)).setSecond(n.getPosition().x + n.getSize().x);
                continue;
            }
            if (n.getPosition().y < (Double)((Pair)levels.get(curLevel)).getFirst()) {
                ((Pair)levels.get(curLevel)).setFirst(n.getPosition().y);
            }
            if (!(n.getPosition().y + n.getSize().y > (Double)((Pair)levels.get(curLevel)).getSecond())) continue;
            ((Pair)levels.get(curLevel)).setSecond(n.getPosition().y + n.getSize().y);
        }
        for (TNode n : tGraph.getNodes()) {
            curLevel = n.getProperty(MrTreeOptions.TREE_LEVEL);
            n.setProperty(InternalProperties.LEVELMIN, (Double)((Pair)levels.get(curLevel)).getFirst());
            n.setProperty(InternalProperties.LEVELMAX, (Double)((Pair)levels.get(curLevel)).getSecond());
        }
        progressMonitor.done();
    }
}

