# Runtime Info package

The runtime information package exposes information about the Pony runtime that
can be queried at runtime. The most common usage at this time is limiting the
number of work based on the number of available schedulers.

For example, in an application that is doing parallel processing and wants to
limit the number of processing actors to the maximum number that could be run
at one time, you can use `Scheduler.schedulers` to get the scheduler
information.

```pony
use "collections"
use "runtime_info"

actor Processor

actor Main
  new create(env: Env) =>
    let s = Scheduler.schedulers(SchedulerInfoAuth(env.root))
    for i in Range(0, s) do
      Processor
    end
```


## Public Types

* [primitive ActorStats](runtime_info-ActorStats.md)
* [primitive ActorStatsAuth](runtime_info-ActorStatsAuth.md)
* [primitive Scheduler](runtime_info-Scheduler.md)
* [primitive SchedulerInfoAuth](runtime_info-SchedulerInfoAuth.md)
* [primitive SchedulerStats](runtime_info-SchedulerStats.md)
* [primitive SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md)


## Private Types

* [struct _ActorStats](runtime_info-_ActorStats.md)
* [struct _SchedulerStats](runtime_info-_SchedulerStats.md)
