/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.GraalJSException;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AbstractModuleRecord;
import com.oracle.truffle.js.runtime.objects.CyclicModuleRecord;
import com.oracle.truffle.js.runtime.objects.ExportResolution;
import com.oracle.truffle.js.runtime.objects.JSModuleRecord;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Consumer;

public final class SyntheticModuleRecord
extends AbstractModuleRecord {
    private final List<TruffleString> exportedNames;
    private Consumer<SyntheticModuleRecord> evaluationSteps;
    private CyclicModuleRecord.Status status = CyclicModuleRecord.Status.New;

    public SyntheticModuleRecord(JSContext context, Source source, Object hostDefined, List<TruffleString> exportedNames, Consumer<SyntheticModuleRecord> evaluationSteps) {
        this(context, source, hostDefined, SharedData.fromExportNames(exportedNames), evaluationSteps);
    }

    public SyntheticModuleRecord(JSContext context, Source source, Object hostDefined, SharedData shared, Consumer<SyntheticModuleRecord> evaluationSteps) {
        super(context, source, hostDefined, shared.frameDescriptor);
        this.exportedNames = Objects.requireNonNull(shared.exportNames);
        this.evaluationSteps = Objects.requireNonNull(evaluationSteps);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSPromiseObject loadRequestedModules(JSRealm realm, Object hostDefinedArg) {
        PromiseCapabilityRecord pc = NewPromiseCapabilityNode.createDefault(realm);
        JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, pc.getResolve(), (Object)Undefined.instance));
        return (JSPromiseObject)pc.getPromise();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void link(JSRealm realm) {
        if (this.getEnvironment() != null) {
            return;
        }
        this.initializeEnvironment();
        this.status = CyclicModuleRecord.Status.Linked;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JSPromiseObject evaluate(JSRealm realm) {
        PromiseCapabilityRecord pc = NewPromiseCapabilityNode.createDefault(realm);
        try {
            this.evaluateSync(realm);
            JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, pc.getResolve(), (Object)Undefined.instance));
        }
        catch (AbstractTruffleException e) {
            AbstractTruffleException errorObj = e instanceof GraalJSException ? ((GraalJSException)e).getErrorObject() : e;
            JSFunction.call(JSArguments.createOneArg((Object)Undefined.instance, pc.getReject(), (Object)errorObj));
        }
        return (JSPromiseObject)pc.getPromise();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void evaluateSync(JSRealm realm) {
        if (this.evaluationSteps == null) {
            return;
        }
        try {
            this.evaluationSteps.accept(this);
            this.evaluationSteps = null;
        }
        finally {
            this.status = CyclicModuleRecord.Status.Evaluated;
        }
    }

    @Override
    public Collection<TruffleString> getExportedNames(Set<JSModuleRecord> exportStarSet) {
        return this.exportedNames;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public ExportResolution resolveExport(TruffleString exportName, Set<Pair<? extends AbstractModuleRecord, TruffleString>> resolveSet) {
        for (TruffleString name : this.getExportedNames()) {
            if (!name.equals((Object)exportName)) continue;
            return ExportResolution.resolved(this, name);
        }
        return ExportResolution.notFound();
    }

    private static FrameDescriptor createFrameDescriptor(Collection<TruffleString> exportNames) {
        FrameDescriptor.Builder b = FrameDescriptor.newBuilder((int)exportNames.size());
        b.defaultValue((Object)Undefined.instance);
        for (TruffleString name : exportNames) {
            b.addSlot(FrameSlotKind.Illegal, (Object)name, null);
        }
        return b.build();
    }

    private void initializeEnvironment() {
        MaterializedFrame env = Truffle.getRuntime().createMaterializedFrame(JSArguments.EMPTY_ARGUMENTS_ARRAY, this.getFrameDescriptor());
        this.setEnvironment(env);
    }

    @CompilerDirectives.TruffleBoundary
    public void setSyntheticModuleExport(TruffleString exportName, Object exportValue) {
        MaterializedFrame frame = this.getEnvironment();
        FrameDescriptor frameDescriptor = frame.getFrameDescriptor();
        OptionalInt frameSlot = JSFrameUtil.findOptionalFrameSlotIndex(frameDescriptor, exportName);
        if (!frameSlot.isPresent()) {
            throw Errors.createReferenceError("Export '" + String.valueOf(exportName) + "' is not defined in module");
        }
        frame.setObject(frameSlot.getAsInt(), exportValue);
    }

    @Override
    public Object getModuleSource() {
        throw Errors.createSyntaxError("Source phase import is not available for Synthetic Module");
    }

    @Override
    public CyclicModuleRecord.Status getStatus() {
        return this.status;
    }

    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return "SyntheticModule@" + Integer.toHexString(System.identityHashCode(this)) + "[source=" + String.valueOf(this.getSource()) + "]";
    }

    public record SharedData(List<TruffleString> exportNames, FrameDescriptor frameDescriptor) {
        public static SharedData fromExportNames(List<TruffleString> exportNames) {
            List<TruffleString> sortedNames = SharedData.toSorted(exportNames, AbstractTruffleString::compareCharsUTF16Uncached);
            return new SharedData(sortedNames, SyntheticModuleRecord.createFrameDescriptor(sortedNames));
        }

        private static <T> List<T> toSorted(List<T> list, Comparator<T> comparator) {
            Object[] names = list.toArray();
            Arrays.sort(names, comparator);
            return List.of(names);
        }
    }
}

