/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import org.firebirdsql.jdbc.escape.FBSQLParseException;
import org.firebirdsql.jdbc.escape.PatternSQLFunction;
import org.firebirdsql.jdbc.escape.SQLFunction;

final class CharacterLengthFunction
implements SQLFunction {
    private static final SQLFunction CHAR_LENGTH_FUNCTION = new PatternSQLFunction("CHAR_LENGTH({0})");
    private static final SQLFunction OCTET_LENGTH_FUNCTION = new PatternSQLFunction("OCTET_LENGTH({0})");

    CharacterLengthFunction() {
    }

    @Override
    public String apply(String ... parameters) throws FBSQLParseException {
        switch (parameters.length) {
            case 1: {
                return CHAR_LENGTH_FUNCTION.apply(parameters);
            }
            case 2: {
                String typeParam = parameters[1].trim();
                if ("CHARACTERS".equalsIgnoreCase(typeParam)) {
                    return CHAR_LENGTH_FUNCTION.apply(parameters);
                }
                if ("OCTETS".equalsIgnoreCase(typeParam)) {
                    return OCTET_LENGTH_FUNCTION.apply(parameters);
                }
                throw new FBSQLParseException("Second parameter for CHAR(ACTER)_LENGTH must be OCTETS or CHARACTERS, was " + parameters[1]);
            }
        }
        throw new FBSQLParseException("Expected 1 or 2 parameters for CHAR(ACTER)_LENGTH, received " + parameters.length);
    }
}

