/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.iterator;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.iterator.PZip;
import com.oracle.graal.python.builtins.objects.iterator.ZipBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.iterator.ZipBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.IteratorExhausted;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PZip})
public final class ZipBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ZipBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ZipBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization
        Object doit(VirtualFrame frame, PZip self, Object state, @Cached PyObjectIsTrueNode isTrueNode) {
            self.setStrict(isTrueNode.execute((Frame)frame, state));
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reduce(PZip self, @Bind Node inliningTarget, @Cached InlinedConditionProfile strictProfile, @Cached GetClassNode getClass, @Bind PythonLanguage language) {
            Object[] objectArray;
            Object type = getClass.execute(inliningTarget, self);
            PTuple tuple = PFactory.createTuple(language, self.getIterators());
            if (strictProfile.profile(inliningTarget, self.isStrict())) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = type;
                objectArray2[1] = tuple;
                objectArray = objectArray2;
                objectArray2[2] = true;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = type;
                objectArray = objectArray3;
                objectArray3[1] = tuple;
            }
            Object[] elements = objectArray;
            return PFactory.createTuple(language, elements);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object doPZip(PZip self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization(guards={"isEmpty(self.getIterators())"})
        static Object doEmpty(PZip self) {
            throw NextNode.iteratorExhausted();
        }

        @Specialization(guards={"!isEmpty(self.getIterators())", "!self.isStrict()"})
        static Object doNext(VirtualFrame frame, PZip self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached TpSlots.GetObjectSlotsNode getSlots, @Cached TpSlotIterNext.CallSlotTpIterNextNode callIterNext) {
            Object[] iterators = self.getIterators();
            Object[] tupleElements = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                Object it = iterators[i];
                tupleElements[i] = callIterNext.execute(frame, inliningTarget, getSlots.execute(inliningTarget, it).tp_iternext(), it);
            }
            return PFactory.createTuple(language, tupleElements);
        }

        @Specialization(guards={"!isEmpty(self.getIterators())", "self.isStrict()"})
        static Object doNext(VirtualFrame frame, PZip self, @Bind Node inliningTarget, @Bind PythonLanguage language, @Cached PyIterNextNode nextNode, @Cached PRaiseNode raiseNode) {
            Object[] iterators = self.getIterators();
            Object[] tupleElements = new Object[iterators.length];
            for (int i = 0; i < iterators.length; ++i) {
                try {
                    tupleElements[i] = nextNode.execute((Frame)frame, inliningTarget, iterators[i]);
                    continue;
                }
                catch (IteratorExhausted e) {
                    if (i > 0) {
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.ZIP_ARG_D_IS_SHORTER_THEN_ARG_SD, i + 1, i == 1 ? " " : "s 1-", i);
                    }
                    for (i = 1; i < iterators.length; ++i) {
                        try {
                            nextNode.execute((Frame)frame, inliningTarget, iterators[i]);
                        }
                        catch (IteratorExhausted e1) {
                            continue;
                        }
                        throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.ZIP_ARG_D_IS_LONGER_THEN_ARG_SD, i + 1, i == 1 ? " " : "s 1-", i);
                    }
                    throw e;
                }
            }
            return PFactory.createTuple(language, tupleElements);
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="zip", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class ZipNode
    extends PythonBuiltinNode {
        static boolean isNoneOrEmptyPKeyword(Object value) {
            PKeyword[] kw;
            return PGuards.isPNone(value) || value instanceof PKeyword[] && (kw = (PKeyword[])value).length == 0;
        }

        @Specialization(guards={"isNoneOrEmptyPKeyword(kw)"})
        static PZip zip(VirtualFrame frame, Object cls, Object[] args, Object kw, @Bind Node inliningTarget, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape) {
            return ZipNode.zip(frame, inliningTarget, cls, args, false, getIter, getInstanceShape);
        }

        @Specialization(guards={"kw.length == 1"})
        static PZip zip(VirtualFrame frame, Object cls, Object[] args, PKeyword[] kw, @Bind Node inliningTarget, @Cached TruffleString.EqualNode eqNode, @Cached.Exclusive @Cached PyObjectGetIter getIter, @Cached PyObjectIsTrueNode isTrueNode, @Cached InlinedConditionProfile profile, @Cached.Shared @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            if (profile.profile(inliningTarget, eqNode.execute((AbstractTruffleString)kw[0].getName(), (AbstractTruffleString)StringLiterals.T_STRICT, PythonUtils.TS_ENCODING))) {
                return ZipNode.zip(frame, inliningTarget, cls, args, isTrueNode.execute((Frame)frame, kw[0].getValue()), getIter, getInstanceShape);
            }
            throw raiseNode.raise(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_IS_AN_INVALID_ARG_FOR_S, kw[0].getName(), BuiltinNames.T_ZIP);
        }

        @Specialization(guards={"kw.length != 1"})
        static Object zip(Object cls, Object[] args, PKeyword[] kw, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonErrorType.TypeError, ErrorMessages.S_TAKES_AT_MOST_ONE_KEYWORD_ARGUMENT_D_GIVEN, BuiltinNames.T_ZIP, kw.length);
        }

        private static PZip zip(VirtualFrame frame, Node inliningTarget, Object cls, Object[] args, boolean strict, PyObjectGetIter getIter, TypeNodes.GetInstanceShape getInstanceShape) {
            Object[] iterables = new Object[args.length];
            LoopNode.reportLoopCount((Node)inliningTarget, (int)args.length);
            for (int i = 0; i < args.length; ++i) {
                Object item = args[i];
                iterables[i] = getIter.execute((Frame)frame, inliningTarget, item);
            }
            return PFactory.createZip(PythonLanguage.get(inliningTarget), cls, getInstanceShape.execute(cls), iterables, strict);
        }
    }
}

