/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.PyUnicodeDecode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyUnicodeFromEncodedObject
extends PNodeWithContext {
    public abstract Object execute(Frame var1, Node var2, Object var3, Object var4, Object var5);

    @Specialization
    static Object doBytes(VirtualFrame frame, Node inliningTarget, PBytes object, Object encoding, Object errors, @Cached.Exclusive @Cached InlinedConditionProfile emptyStringProfile, @Cached.Exclusive @Cached PyUnicodeDecode decode) {
        if (emptyStringProfile.profile(inliningTarget, object.getSequenceStorage().length() == 0)) {
            return StringLiterals.T_EMPTY_STRING;
        }
        return decode.execute((Frame)frame, inliningTarget, object, encoding, errors);
    }

    @Specialization
    static Object doString(VirtualFrame frame, TruffleString object, Object encoding, Object errors, @Bind Node inliningTarget) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DECODING_STR_NOT_SUPPORTED);
    }

    @Specialization
    static Object doPString(VirtualFrame frame, PString object, Object encoding, Object errors, @Bind Node inliningTarget) {
        throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.DECODING_STR_NOT_SUPPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(guards={"!isPBytes(object)", "!isString(object)"}, limit="3")
    static Object doBuffer(VirtualFrame frame, Node inliningTarget, Object object, Object encoding, Object errors, @Bind PythonLanguage language, @Cached(value="createFor($node)") IndirectCallData indirectCallNode, @Cached.Exclusive @Cached InlinedConditionProfile emptyStringProfile, @CachedLibrary(value="object") PythonBufferAcquireLibrary bufferAcquireLib, @Cached.Exclusive @Cached PyUnicodeDecode decode, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
        PythonContext context = PythonContext.get(inliningTarget);
        Object buffer = bufferAcquireLib.acquireReadonly(object, frame, context, context.getLanguage(inliningTarget), indirectCallNode);
        try {
            int len = bufferLib.getBufferLength(buffer);
            if (emptyStringProfile.profile(inliningTarget, len == 0)) {
                TruffleString truffleString = StringLiterals.T_EMPTY_STRING;
                return truffleString;
            }
            PBytes bytes = PFactory.createBytes(language, bufferLib.getInternalOrCopiedByteArray(buffer), len);
            Object object2 = decode.execute((Frame)frame, inliningTarget, bytes, encoding, errors);
            return object2;
        }
        finally {
            bufferLib.release(buffer, frame, indirectCallNode);
        }
    }
}

