/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.function.builtins.clinic;

import com.oracle.graal.python.annotations.ClinicConverterFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.TruffleStringConverterWithDefaultValueNodeGen;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;

public abstract class TruffleStringConverterWithDefaultValueNode
extends TruffleStringConverterNode {
    private final Object defaultValue;
    protected final boolean useDefaultForNone;

    public TruffleStringConverterWithDefaultValueNode(String builtinName, Object defaultValue, boolean useDefaultForNone) {
        super(builtinName);
        assert (!(defaultValue instanceof String)) : "j.l.String used as default for TString converter";
        this.defaultValue = defaultValue;
        this.useDefaultForNone = useDefaultForNone;
    }

    @Specialization(guards={"!useDefaultForNone", "isNoValue(none)"})
    Object doNoValue(PNone none) {
        return this.defaultValue;
    }

    @Specialization(guards={"useDefaultForNone"})
    Object doNoValueAndNone(PNone none) {
        return this.defaultValue;
    }

    @Override
    protected final boolean shouldUseDefaultValue(Object value) {
        return TruffleStringConverterWithDefaultValueNode.isHandledPNone(this.useDefaultForNone, value);
    }

    @ClinicConverterFactory
    @NeverDefault
    public static TruffleStringConverterWithDefaultValueNode create(@ClinicConverterFactory.BuiltinName String builtinName, @ClinicConverterFactory.DefaultValue Object defaultValue, @ClinicConverterFactory.UseDefaultForNone boolean useDefaultForNone) {
        return TruffleStringConverterWithDefaultValueNodeGen.create(builtinName, defaultValue, useDefaultForNone);
    }
}

