/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.factory;

import com.ibm.db2.cmx.runtime.Data;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.generator.BaseData;
import com.ibm.db2.cmx.runtime.internal.CentralStore;
import com.ibm.db2.cmx.runtime.internal.CentralStoreKey;
import com.ibm.db2.cmx.runtime.internal.DataProperties;
import com.ibm.db2.cmx.runtime.internal.PdqServiceThreadProvider;
import com.ibm.db2.cmx.runtime.internal.PdqTimerServices;
import com.ibm.db2.cmx.runtime.internal.db.JdbcData;
import com.ibm.db2.cmx.runtime.internal.db.QueryOverCollectionData;
import com.ibm.db2.cmx.runtime.internal.db.QueryOveryCollectionConnectionHelper;
import com.ibm.db2.cmx.runtime.internal.db.db2.DB2JdbcData;
import com.ibm.db2.cmx.runtime.internal.db.db2.DB2StaticData;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.runtime.internal.trace.DataLogger;
import com.ibm.db2.cmx.runtime.internal.trace.Log;
import com.ibm.db2.cmx.runtime.statement.Hook;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class DataFactory {
    private static boolean isInitialized = false;
    public static boolean isPropertiesCacheInitialized__ = false;
    private static Integer queryTimeout__;
    private static Integer maxRows__;

    private static synchronized void init() {
        if (!isInitialized) {
            CentralStoreKey centralStoreKey = DataProperties.getGlobalCentralStoreKey();
            if (centralStoreKey != null) {
                if (centralStoreKey.getKeyType() == CentralStoreKey.CentralStoreKeyType.FILE_SYSTEM) {
                    DataFactory.processRepositoryDataFactoryX(centralStoreKey);
                } else {
                    PdqServiceThreadProvider.executeOnServiceThreadIfNeeded(PdqServiceThreadProvider.ServiceThreadRequest.DATA_FACTORY_INIT, null, false, centralStoreKey);
                }
            }
            isInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processRepositoryDataFactoryX(CentralStoreKey centralStoreKey) {
        DataProperties.RepositoryRequiredValue repositoryRequiredValue;
        Properties properties = new Properties();
        Throwable throwable = null;
        try {
            CentralStore.fetchFromCentralStore(CentralStore.CentralStoreFlags.FETCH_PROPERTIES, centralStoreKey, properties);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            try {
                centralStoreKey.closeCon();
            }
            catch (Exception exception) {}
        }
        try {
            repositoryRequiredValue = DataProperties.parseRepositoryRequiredValue(DataProperties.getProperty("pdq.repositoryRequired"), centralStoreKey, null);
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, sQLException.getMessage(), sQLException, 11039);
        }
        if (null == throwable) {
            throwable = centralStoreKey.getExceptionChain();
        }
        if (throwable != null) {
            if (DataProperties.RepositoryRequiredValue.REQUIRED_AT_STARTUP == repositoryRequiredValue || DataProperties.RepositoryRequiredValue.REQUIRED_AT_STARTUP_AND_FOR_OUTPUT == repositoryRequiredValue) {
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_REPOSITORY_REQUIRED_BUT_UNAVAILABLE", "pureQuery Runtime", "pdq.repositoryRequired", repositoryRequiredValue.getPropertyValue()) + DataProperties.getMessageDescribingPropertyLocations(centralStoreKey, null, false, "  "), throwable, 10899);
            }
            Logger logger = Log.getAPILogger();
            String string = "Cannot connect to repository" + throwable.getMessage();
            DataLogger.logConfigHighVis(logger, DataProperties.class, "init", string, true);
        }
        long l2 = Long.parseLong(DataProperties.getProperty("pdq.propertiesRefreshInterval"));
        DataProperties.resetPropertiesBeforeMergingWithCentralStoreProperties();
        DataProperties.mergeProperties(properties);
        long l3 = Long.parseLong(DataProperties.getProperty("pdq.propertiesRefreshInterval"));
        if (l3 == 0L) {
            DataProperties.setProperty("pdq.propertiesRefreshInterval", l2 + "");
            l3 = l2;
        }
        PdqTimerServices.addToModificationDetectionQueue(DataProperties.getGlobalCentralStoreKey(), l3);
    }

    public static Data getData() {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, null);
    }

    public static Data getData(Hook hook) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(hook, null);
    }

    public static Data getData(Hook hook, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(hook, map);
    }

    public static Data getData(Connection connection) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, connection, null, null, null);
    }

    public static Data getData(Connection connection, Hook hook) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, connection, hook, null, null);
    }

    public static Data getData(Connection connection, Hook hook, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, connection, hook, map, null);
    }

    public static Data getData(Connection connection, Hook hook, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, connection, hook, null, properties);
    }

    public static Data getData(Connection connection, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, connection, null, map, null);
    }

    public static Data getData(Connection connection, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(null, connection, null, null, properties);
    }

    public static Data getData(DataSource dataSource) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), null, null, null);
    }

    public static Data getData(DataSource dataSource, Hook hook) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), hook, null, null);
    }

    public static Data getData(DataSource dataSource, Hook hook, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), hook, map, null);
    }

    public static Data getData(DataSource dataSource, Hook hook, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), hook, null, properties);
    }

    public static Data getData(DataSource dataSource, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), null, map, null);
    }

    public static Data getData(DataSource dataSource, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), null, null, properties);
    }

    public static <T> T getData(Class<T> clazz) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, null));
    }

    public static <T> T getData(Class<T> clazz, Hook hook) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(hook, null));
    }

    public static <T> T getData(Class<T> clazz, Hook hook, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(hook, map));
    }

    public static <T> T getData(Class<T> clazz, Connection connection) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, null, null, null));
    }

    public static <T> T getData(Class<T> clazz, Connection connection, Hook hook) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, hook, null, null));
    }

    public static <T> T getData(Class<T> clazz, Connection connection, Hook hook, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, hook, map, null));
    }

    public static <T> T getData(Class<T> clazz, Connection connection, Hook hook, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, hook, null, properties));
    }

    public static <T> T getData(Class<T> clazz, Connection connection, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, null, map, null));
    }

    public static <T> T getData(Class<T> clazz, Connection connection, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, null, null, properties));
    }

    public static <T> T getData(Class<T> clazz, DataSource dataSource) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), null, null, null));
    }

    public static <T> T getData(Class<T> clazz, DataSource dataSource, Hook hook) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), hook, null, null));
    }

    public static <T> T getData(Class<T> clazz, DataSource dataSource, Hook hook, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), hook, map, null));
    }

    public static <T> T getData(Class<T> clazz, DataSource dataSource, Hook hook, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), hook, null, properties));
    }

    public static <T> T getData(Class<T> clazz, DataSource dataSource, Map<Object, Object> map) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), null, map, null));
    }

    public static <T> T getData(Class<T> clazz, DataSource dataSource, Properties properties) {
        if (!isInitialized) {
            DataFactory.init();
        }
        return DataFactory.getInstance(clazz, DataFactory.getData_(dataSource, DataFactory.getDatabaseConnection(dataSource), null, null, properties));
    }

    public static <T> T getData(Class<T> clazz, Data data) {
        if (!isInitialized) {
            DataFactory.init();
        }
        if (null == data) {
            String string = DataFactory.class + "#getData (Class<T> interfaceClass, Data data)";
            String string2 = "Data data";
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_METHOD_NULL_ARG", string, string2), null, 10289);
        }
        if (data instanceof BaseData) {
            data = ((BaseData)data).getData();
        }
        return DataFactory.getInstance(clazz, data);
    }

    static <T> T getDataIgnoreRepositoryRequired(Class<T> clazz, Connection connection, Properties properties) {
        return DataFactory.getInstance(clazz, DataFactory.getData_(null, connection, null, null, properties));
    }

    private static DB_TYPE getDbType(DatabaseMetaData databaseMetaData) {
        try {
            String string = databaseMetaData.getDatabaseProductName();
            if (string.startsWith("DB2") || string.startsWith("AS")) {
                return DB_TYPE.DB2;
            }
            if (string.startsWith("IDS")) {
                return DB_TYPE.IDS;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return DB_TYPE.OTHER;
    }

    private static boolean determineIfExecutionModeIsStatic(String string, boolean bl2) {
        if (string != null && string.equalsIgnoreCase("STATIC")) {
            return true;
        }
        if (string != null && !string.equalsIgnoreCase("DYNAMIC")) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_INV_EXEC_MODE", string) + DataProperties.getMessageDescribingPropertyLocations(null, null, bl2, "  "), null, 10002);
        }
        return false;
    }

    private static Data getData_(DataSource dataSource, Connection connection, Hook hook, Map<Object, Object> map, Properties properties) {
        Integer n2;
        Integer n3;
        boolean bl2;
        boolean bl3 = bl2 = null != properties && !properties.isEmpty();
        if (bl2) {
            n3 = DataProperties.getPropertyInteger(properties, "pdq.queryTimeoutInSeconds", bl2);
            n2 = DataProperties.getPropertyInteger(properties, "pdq.maxResultRows", bl2);
        } else if (isPropertiesCacheInitialized__) {
            n3 = queryTimeout__;
            n2 = maxRows__;
        } else {
            n3 = DataProperties.getPropertyInteger(properties, "pdq.queryTimeoutInSeconds", bl2);
            n2 = DataProperties.getPropertyInteger(properties, "pdq.maxResultRows", bl2);
            queryTimeout__ = n3;
            maxRows__ = n2;
            isPropertiesCacheInitialized__ = true;
        }
        DatabaseMetaData databaseMetaData = null;
        try {
            databaseMetaData = connection.getMetaData();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        DB_TYPE dB_TYPE = DataFactory.getDbType(databaseMetaData);
        if (dB_TYPE == DB_TYPE.DB2) {
            if (DataFactory.determineIfExecutionModeIsStatic(DataProperties.getProperty(properties, "pdq.executionMode"), bl2)) {
                return DataFactory.getStaticData(dataSource, connection, hook, map, n3, n2, databaseMetaData);
            }
            return DataFactory.getDB2DynamicData(dataSource, connection, hook, map, n3, n2, databaseMetaData);
        }
        if (dB_TYPE == DB_TYPE.IDS) {
            return DataFactory.getDB2DynamicData(dataSource, connection, hook, map, n3, n2, databaseMetaData);
        }
        return DataFactory.getDynamicData(dataSource, connection, hook, map, n3, n2, databaseMetaData);
    }

    private static Data getData_(Hook hook, Map<Object, Object> map) {
        Integer n2 = DataProperties.getPropertyInteger(null, "pdq.queryTimeoutInSeconds", false);
        Integer n3 = DataProperties.getPropertyInteger(null, "pdq.maxResultRows", false);
        return new QueryOverCollectionData(DataFactory.getQocConnection(), hook, map, n2, n3);
    }

    private static Connection getDatabaseConnection(DataSource dataSource) {
        try {
            return dataSource.getConnection();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CONN", new Object[0]), sQLException, 10003);
        }
    }

    private static Data getDB2DynamicData(DataSource dataSource, Connection connection, Hook hook, Map<Object, Object> map, Integer n2, Integer n3, DatabaseMetaData databaseMetaData) {
        DB2JdbcData dB2JdbcData = new DB2JdbcData(connection, hook, map, n2, n3, databaseMetaData);
        return dB2JdbcData;
    }

    private static Data getDynamicData(DataSource dataSource, Connection connection, Hook hook, Map<Object, Object> map, Integer n2, Integer n3, DatabaseMetaData databaseMetaData) {
        JdbcData jdbcData = new JdbcData(connection, hook, map, n2, n3, databaseMetaData);
        return jdbcData;
    }

    private static <T> T getInstance(Class<T> clazz, Data data) {
        T t2 = null;
        try {
            t2 = (T)DataFactory.getClassForNameUseClassLoaderOfClass(clazz.getName() + "Impl", clazz).newInstance();
            BaseData baseData = (BaseData)t2;
            baseData.setData(data);
        }
        catch (InstantiationException instantiationException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(data, Messages.getText("ERR_INSTANTIATE", clazz.getName() + "Impl."), instantiationException, 10004);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(data, Messages.getText("ERR_INSTANTIATE", clazz.getName() + "Impl."), illegalAccessException, 10005);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(data, Messages.getText("ERR_INSTANTIATE", clazz.getName() + "Impl."), classNotFoundException, 10006);
        }
        catch (ClassCastException classCastException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(data, Messages.getText("ERR_INSTANTIATE", clazz.getName()), classCastException, 10007);
        }
        return t2;
    }

    private static Connection getQocConnection() {
        try {
            return QueryOveryCollectionConnectionHelper.getConnection();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_CONN", new Object[0]), sQLException, 10008);
        }
    }

    private static Data getStaticData(DataSource dataSource, Connection connection, Hook hook, Map<Object, Object> map, Integer n2, Integer n3, DatabaseMetaData databaseMetaData) {
        DB2StaticData dB2StaticData = new DB2StaticData(connection, hook, map, n2, n3, databaseMetaData);
        return dB2StaticData;
    }

    private static Class<?> getClassForNameUseClassLoaderOfClass(String string, Class clazz) throws ClassNotFoundException {
        return DataFactory.getClassForNameUseClassLoaderOfClassNonPriv(string, clazz);
    }

    private static Class<?> getClassForNameUseClassLoaderOfClassNonPriv(String string, Class clazz) throws ClassNotFoundException {
        return Class.forName(string, true, clazz.getClassLoader());
    }

    static enum DB_TYPE {
        DB2,
        IDS,
        OTHER;

    }
}

