
/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of a free software library; you can redistribute
 * it and/or modify it under the terms of the GNU Lesser General
 * Public License version 2.1 as published by the Free Software
 * Foundation and shipped in the \"COPYING.LIB\" file with this library.
 * The library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY of any kind.
 *
 * Oracle LGPL Disclaimer: For the avoidance of doubt, except that if
 * any license choice other than GPL or LGPL is available it will
 * apply instead, Oracle elects to use only the Lesser General Public
 * License version 2.1 (LGPLv2) at this time for any software where
 * a choice of LGPL license versions is made available with the
 * language indicating that LGPLv2 or any later version may be used,
 * or where a choice of which version of the LGPL is applied is
 * otherwise unspecified.

 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * SPDX-License-Identifier: LGPL-2.1-only
 */

/*
 * IHostX86.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_7_2;

import org.virtualbox_7_2.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The x86-specific interface for the physical host machine.

Interface ID: <code>{50C97996-9CF8-417F-BD79-1E0471367CD3}</code>
*/
public class IHostX86 extends IUnknown
{

    public IHostX86(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }
    public static IHostX86 queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IHostX86(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }

/**
Returns the CPU cpuid information for the specified leaf.
@param cpuId Identifier of the CPU. The CPU must be online.

@param leaf CPUID leaf index (eax).

@param subLeaf CPUID leaf sub index (ecx). This currently only applies to cache
information on Intel CPUs. Use 0 if retrieving values for{@link org.virtualbox_7_2.IPlatformX86#setCPUIDLeaf(Long,Long,Long,Long,Long,Long)}.

@param valEax CPUID leaf value for register eax.

@param valEbx CPUID leaf value for register ebx.

@param valEcx CPUID leaf value for register ecx.

@param valEdx CPUID leaf value for register edx.

NOTE: The current implementation might not necessarily return the
description for this exact CPU.

*/
    public void getProcessorCPUIDLeaf(Long cpuId, Long leaf, Long subLeaf, Holder<Long> valEax, Holder<Long> valEbx, Holder<Long> valEcx, Holder<Long> valEdx)
    {
        try
        {
        javax.xml.ws.Holder<Long> tmp_valEax = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEbx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEcx = new javax.xml.ws.Holder<Long>();
        javax.xml.ws.Holder<Long> tmp_valEdx = new javax.xml.ws.Holder<Long>();
        port.iHostX86GetProcessorCPUIDLeaf(obj, cpuId, leaf, subLeaf, tmp_valEax, tmp_valEbx, tmp_valEcx, tmp_valEdx);
        valEax.value = tmp_valEax.value;
        valEbx.value = tmp_valEbx.value;
        valEcx.value = tmp_valEcx.value;
        valEdx.value = tmp_valEdx.value;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
}
