package App::Manoc::Search::Widget::ApplyRole;

use Moose::Role;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use Class::Load qw/ load_optional_class /;
use namespace::autoclean;

sub apply_widget_role {
    my ( $self, $target, $widget_class ) = @_;

    my $render_role = $self->get_widget_role($widget_class);
    $render_role->meta->apply($target) if $render_role;
}

sub get_widget_role {
    my ( $self, $widget_class ) = @_;

    my @name_spaces = ( 'App::Manoc::Search::Widget', 'ManocX::Search::Widget' );
    my @classes;
    if ( $widget_class =~ s/^\+// ) {
        push @classes, $widget_class;
    }
    foreach my $ns (@name_spaces) {
        push @classes, $ns . '::' . $widget_class;
    }
    foreach my $try (@classes) {
        return $try if load_optional_class($try);
    }
    die "Can't find widget $widget_class from " . join( ", ", @name_spaces );
}

1;

__END__

=pod

=head1 NAME

App::Manoc::Search::Widget::ApplyRole

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
