package App::Manoc::View::JSON;

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use base 'Catalyst::View::JSON';

use JSON qw();


__PACKAGE__->config( 'expose_stash' => 'json_data', );


sub encode_json {
    my ( $self, $c, $data ) = @_;

    if ( not defined($data) ) {
        $c->response->status(403);
        $c->detach();
        return;
    }

    my $encoder = JSON::MaybeXS->new(
        utf8            => 1,
        allow_blessed   => 1,
        convert_blessed => 1,
    );
    return $encoder->encode($data);
}


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::View::JSON

=head1 VERSION

version 2.99.4

=head1 SYNOPSIS

  sub list_js : Chained('object_list') : PathPart('js') : Args(0) {
    my ( $self, $c ) = @_;

    $c->stash( json_data => \@my_list );
    $c->forward('View::JSON');
  }

=head1 NAME

App::Manoc::View::JSON - Catalyst JSON View

=for Pod::Coverage encode_json

=head1 SEE ALSO

L<Catalyst::View::JSON>

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
