# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableReplica;
  use Moose;
  has GlobalSecondaryIndexes => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsDynamoDbTableReplicaGlobalSecondaryIndex]');
  has KmsMasterKeyId => (is => 'ro', isa => 'Str');
  has ProvisionedThroughputOverride => (is => 'ro', isa => 'Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughputOverride');
  has RegionName => (is => 'ro', isa => 'Str');
  has ReplicaStatus => (is => 'ro', isa => 'Str');
  has ReplicaStatusDescription => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableReplica

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableReplica object:

  $service_obj->Method(Att1 => { GlobalSecondaryIndexes => $value, ..., ReplicaStatusDescription => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableReplica object:

  $result = $service_obj->Method(...);
  $result->Att1->GlobalSecondaryIndexes

=head1 DESCRIPTION

Information about a replica of a DynamoDB table.

=head1 ATTRIBUTES


=head2 GlobalSecondaryIndexes => ArrayRef[L<Paws::SecurityHub::AwsDynamoDbTableReplicaGlobalSecondaryIndex>]

List of global secondary indexes for the replica.


=head2 KmsMasterKeyId => Str

The identifier of the AWS KMS customer master key (CMK) that will be
used for AWS KMS encryption for the replica.


=head2 ProvisionedThroughputOverride => L<Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughputOverride>

Replica-specific configuration for the provisioned throughput.


=head2 RegionName => Str

The name of the Region where the replica is located.


=head2 ReplicaStatus => Str

The current status of the replica.


=head2 ReplicaStatusDescription => Str

Detailed information about the replica status.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

