# -*- cperl -*-
# ABSTRACT: LaTeX bracketconstruction (math) object


use strict;
use warnings;
package SpeL::Object::Bracketconstruction;

use parent 'Exporter';
use Carp;
use SpeL::I18n;
use SpeL::Object::MathUnit;




sub read {
  my $self = shift;
  my ( $level ) = @_;

  $self->{obracket} =~ s/\\left\s*//;
  $self->{cbracket} =~ s/\\right\s*//;
  my $matchof = {
		 '('  => ')',
		 '['  => ']',
		 '{' => '}',
		 '\{' => '\}',
		 '|'  => '|',
		 '\|' => '\|',
		 '.'  => '.',
		};  
  if ( $matchof->{$self->{obracket}} eq $self->{cbracket} ) {
    if ( $self->{obracket} =~ /\(|\[|\{|\\\{/ ) {
      return $self->{Component}->read( $level + 1 );
    }
    elsif ( $self->{obracket} eq '|' ) {
      return $SpeL::I18n::lh->maketext( 'Absval',
					$self->{Component}->read( $level + 1 ) );
    }
    elsif ( $self->{obracket} eq '\|' ) {
      return $SpeL::I18n::lh->maketext( 'Norm',
					$self->{Component}->read( $level + 1 ) );
    }
  }
  else {
    if ( $self->{obracket} eq '.' ) {
      if ( $self->{cbracket} eq '|' ) {
	return $SpeL::I18n::lh->maketext( 'Subjectto',
					  $self->{Component}->read( $level + 1 ) );
      }
    }
    if ( $self->{cbracket} eq '.' ) {
      return $self->{Component}->read( $level + 1 );
    }
  }
  die( "Error: I don't know how to read a construct with\n" .
       "       left bracket '$self->{obracket}' and\n" .
       "       right bracket '$self->{cbracket}'.\n" .
       "       If you know how  you would like to have it read out loud,\n" .
       "       send it to the maintainer of this  package.\n" .
       "       (mailto:walter.daems\@uantwerpen.be)\n" );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

SpeL::Object::Bracketconstruction - LaTeX bracketconstruction (math) object

=head1 VERSION

version 20241023.0918

=head1 METHODS

=head2 new()

We keep the default method, as the object is generated by the parser.

=head2 read( level )

returns a string with the spoken version of the node

=over 4

=item level: parsing level

=back

=head1 SYNOPSYS

Represents a LaTeX math bracketconstruction

=head1 AUTHOR

Walter Daems <wdaems@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Walter Daems.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=head1 CONTRIBUTOR

=for stopwords Paul Levrie

Paul Levrie

=cut
