# This Makefile.PL for  was generated by Dist::Zilla.
# Don't edit it but the dist.ini used to construct it.

use strict;
use warnings;

use v5.8.8;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Portably access the process table",
  "AUTHOR" => "Brendan Byrd <bbyrd\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {},
  "DISTNAME" => "P9Y-ProcessTable",
  "EXE_FILES" => [],
  "LICENSE" => "artistic_2",
  "MIN_PERL_VERSION" => "5.008008",
  "NAME" => "P9Y::ProcessTable",
  "PREREQ_PM" => {
    &os_deps,
    "List::AllUtils" => 0,
    "Module::Runtime" => "0.002",
    "Moo" => "0.009001",
    "Path::Class" => "0.32",
    "namespace::clean" => 0
  },
  "TEST_REQUIRES" => {
    "Devel::SimpleTrace" => "0.07",
    "ExtUtils::MakeMaker" => "6.31",
    "List::Util" => "1.19",
    "Test::CheckDeps" => "0.002",
    "Test::More" => "0.94",
    "Test::Most" => "0.01"
  },
  "VERSION" => "1.05_02",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  my $tr = delete $WriteMakefileArgs{TEST_REQUIRES};
  my $br = $WriteMakefileArgs{BUILD_REQUIRES};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



sub os_deps {
   if ( $^O eq 'MSWin32' or $^O eq 'cygwin' ) {
      return (
         'Win32::Process'       => 0,
         'Win32::Process::Info' => 1.020,  # WMI on Cygwin
         'Path::Class'          => 0.32,   # fixes Cygwin path issue
      );
   }
   elsif ( $^O eq 'freebsd' ) {
      return ( 'BSD::Process' => 0 );
   }
   elsif ( $^O eq 'os2' ) {
      return ( 'OS2::Process' => 0 );
   }
   elsif ( $^O eq 'VMS' ) {
      return ( 'VMS::Process' => 0 );
   }
   else {
      # let's hope they have /proc
      if ( -d '/proc' and @{[ glob('/proc/*') ]} ) {
         return ();
      }
      # ...or that Proc::ProcessTable can handle it
      else {
         return ( 'Proc::ProcessTable' => 0.48 );  # ie: the one that ain't broke
      }
   }
   return ();
}
