#!/usr/bin/make -f
# This debian/rules file is provided as a template for normal perl
# packages. It was created by Marc Brockschmidt <marc@dch-faq.de> for
# the Debian Perl Group (http://pkg-perl.alioth.debian.org/) but may
# be used freely wherever it is useful.

# Uncomment this to turn on verbose mode.
#export DH_VERBOSE=1

# If set to a true value then MakeMaker's prompt function will
# always return the default without waiting for user input.
export PERL_MM_USE_DEFAULT=1

PERL   ?= /usr/bin/perl
PACKAGE = $(shell dh_listpackages)
TMP     = $(CURDIR)/debian/$(PACKAGE)

# Allow disabling build optimisation by setting noopt in
# $DEB_BUILD_OPTIONS
CFLAGS = -Wall -g
ifneq (,$(findstring noopt,$(DEB_BUILD_OPTIONS)))
        CFLAGS += -O0
else
        CFLAGS += -O2
endif

build: build-stamp
build-stamp:
	dh_testdir
	# Add commands to compile the package here
	$(PERL) Makefile.PL INSTALLDIRS=vendor
	$(MAKE) OPTIMIZE="$(CFLAGS)" LD_RUN_PATH=""
	#TEST#
	touch $@

clean:
	dh_testdir
	dh_testroot
	dh_clean build-stamp install-stamp
	# Add commands to clean up after the build process here
	[ ! -f Makefile ] || $(MAKE) realclean

install: install-stamp
install-stamp: build-stamp
	dh_testdir
	dh_testroot
	dh_clean -k
	# Add commands to install the package into $(TMP)
	$(MAKE) pure_install DESTDIR=$(TMP) PREFIX=/usr
	[ ! -d $(TMP)/usr/share/perl5 ] || \
		rmdir --ignore-fail-on-non-empty --parents --verbose \
		$(TMP)/usr/share/perl5
	touch $@

# Build architecture-independent files here.
binary-indep: build install
# We have nothing to do here for an architecture-dependent package

# Build architecture-dependent files here.
binary-arch: build install
	dh_testdir
	dh_testroot
	dh_installexamples #EXAMPLES#
	dh_installdocs #DOCS#
	dh_installchangelogs #CHANGES#
	dh_shlibdeps
	dh_strip
	dh_perl
	dh_compress
	dh_fixperms
	dh_installdeb
	dh_gencontrol
	dh_md5sums
	dh_builddeb

binary: binary-indep binary-arch
.PHONY: build clean binary-indep binary-arch binary install
