package BioX::CLPM::Fragments;
use base qw(BioX::CLPM::Base);
use BioX::CLPM::Fragments::Simple;
use Class::Std;
use Class::Std::Utils;

use warnings;
use strict;
use Carp;

use version; our $VERSION = qv('0.0.1');

{
        my %sequence_id_of  :ATTR( :get<sequence_id>   :set<sequence_id>   :default<''>    :init_arg<sequence_id> );
        my %list_of         :ATTR( :get<list>          :set<list>          :default<[]>    :init_arg<list> );
        my %index_of        :ATTR( :get<index>         :set<index>         :default<'1'>   :init_arg<index> );
        my %type_of         :ATTR( :get<type>          :set<type>          :default<''>    :init_arg<type> );
                
        sub BUILD {
                my ($self, $ident, $arg_ref) = @_;
                return;
        }

        sub START {
                my ($self, $ident, $arg_ref) = @_;
                return;
        }

        sub list { my ( $self ) = @_; return @{ $self->get_list() }; }
        sub next_index { my ( $self ) = @_; my $index = $self->get_index(); $self->set_index( $index + 1 ); return $index; }

        sub add {
                my ( $self, $arg_ref ) = @_;
		my @fragments   = $self->list();
		my $fragment;
		if ( $self->get_type() eq 'simple' ) {
			my $sequence    = defined $arg_ref->{sequence}   ? $arg_ref->{sequence}   : '';
			my $mass        = defined $arg_ref->{mass}   ? $arg_ref->{mass}   : '';
			my $fragment_id = defined $arg_ref->{fragment_id} ? $arg_ref->{fragment_id} : $self->next_index();
			   $fragment    = BioX::CLPM::Fragments::Simple->new({ 
			             sequence    => $sequence,
        		             mass        => $mass,
        		             fragment_id => $fragment_id,
        		             sequence_id => $self->get_sequence_id() });
		} 
		elsif ( $self->get_type() eq 'linked' ) {
			my $fragment_id_1 = defined $arg_ref->{fragment_id_1} ? $arg_ref->{fragment_id_1} : '';
			my $fragment_id_2 = defined $arg_ref->{fragment_id_2} ? $arg_ref->{fragment_id_2} : '';
			my $mass          = defined $arg_ref->{mass}   ? $arg_ref->{mass}   : '';
			my $mods          = defined $arg_ref->{mods}   ? $arg_ref->{mods}   : '';
			   $fragment      = BioX::CLPM::Fragments::Linked->new({ 
        		             fragment_id_1 => $fragment_id_1,
        		             fragment_id_2 => $fragment_id_2,
        		             mass          => $mass,
        		             mods          => $mods });
		}
		push( @fragments, $fragment );
		$self->set_list( \@fragments );
                return;
        }

}

1; # Magic true value required at end of module
__END__

=head1 NAME

BioX::CLPM::Fragments - Perl Tools for Mass Spec Peptide Matching


=head1 VERSION

This document describes BioX::CLPM::Fragments version 0.0.1


=head1 SYNOPSIS

    use BioX::CLPM::Fragments;

    my $obj = BioX::CLPM::Fragments->new({attribute => 'value'});

    print $obj->get_attribute(), "\n";

    $obj->set_attribute('new value');

    print $obj->get_attribute(), "\n";

=for author to fill in:
    Brief code example(s) here showing commonest usage(s).
    This section will be as far as many users bother reading
    so make it as educational and exeplary as possible.
  
  
=head1 DESCRIPTION

=for author to fill in:
    Write a full description of the module and its features here.
    Use subsections (=head2, =head3) as appropriate.


=head1 INTERFACE 

=for author to fill in:
    Write a separate section listing the public components of the modules
    interface. These normally consist of either subroutines that may be
    exported, or methods that may be called on objects belonging to the
    classes provided by the module.


=head1 DIAGNOSTICS

=for author to fill in:
    List every single error and warning message that the module can
    generate (even the ones that will "never happen"), with a full
    explanation of each problem, one or more likely causes, and any
    suggested remedies.

=over

=item C<< Error message here, perhaps with %s placeholders >>

[Description of error here]

=item C<< Another error message here >>

[Description of error here]

[Et cetera, et cetera]

=back


=head1 CONFIGURATION AND ENVIRONMENT

=for author to fill in:
    A full explanation of any configuration system(s) used by the
    module, including the names and locations of any configuration
    files, and the meaning of any environment variables or properties
    that can be set. These descriptions must also include details of any
    configuration language used.
  
BioX::CLPM::Fragments requires no configuration files or environment variables.


=head1 DEPENDENCIES

=for author to fill in:
    A list of all the other modules that this module relies upon,
    including any restrictions on versions, and an indication whether
    the module is part of the standard Perl distribution, part of the
    module's distribution, or must be installed separately. ]

None.


=head1 INCOMPATIBILITIES

=for author to fill in:
    A list of any modules that this module cannot be used in conjunction
    with. This may be due to name conflicts in the interface, or
    competition for system or program resources, or due to internal
    limitations of Perl (for example, many modules that use source code
    filters are mutually incompatible).

None reported.


=head1 BUGS AND LIMITATIONS

=for author to fill in:
    A list of known problems with the module, together with some
    indication Whether they are likely to be fixed in an upcoming
    release. Also a list of restrictions on the features the module
    does provide: data types that cannot be handled, performance issues
    and the circumstances in which they may arise, practical
    limitations on the size of data sets, special cases that are not
    (yet) handled, etc.

No bugs have been reported.

Please report any bugs or feature requests to
C<bug-biox-clpm-fragments@rt.cpan.org>, or through the web interface at
L<http://rt.cpan.org>.


=head1 AUTHOR

Nathan Crabtree, MidSouth Bioinformatics Center  C<< <crabtree@cpan.org> >>


=head1 LICENSE AND COPYRIGHT

Copyright (c) 2012, Nathan Crabtree, MidSouth Bioinformatics Center C<< <crabtree@cpan.org> >>. All rights reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself. See L<perlartistic>.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT WHEN
OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER PARTIES
PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE
ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE SOFTWARE IS WITH
YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL
NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENSE, BE
LIABLE TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL,
OR CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE
THE SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF
SUCH DAMAGES.
