package Padre::Plugin::YAML;
BEGIN {
  $Padre::Plugin::YAML::VERSION = '0.01';
}

# ABSTRACT: YAML support for Padre

use warnings;
use strict;

use File::Spec::Functions qw{ catfile };

use base 'Padre::Plugin';
use Padre::Wx ();

sub plugin_name {
	Wx::gettext('YAML');
}

sub padre_interfaces {
	'Padre::Plugin' => 0.81, 'Padre::Document' => 0.81;
}

sub registered_documents {
	'text/x-yaml' => 'Padre::Document::YAML';
}

#sub plugin_icon {
#	my $self = shift;

	# find resource path
	#my $iconpath = catfile( $self->plugin_directory_share, 'icons', 'file.png' );

	# create and return icon
	#return Wx::Bitmap->new( $iconpath, Wx::wxBITMAP_TYPE_PNG );
#}

sub menu_plugins_simple {
	my $self = shift;
	return $self->plugin_name => [
		Wx::gettext('About') => sub { $self->show_about },
	];
}

#####################################################################
# Custom Methods

sub show_about {
	my $self = shift;

	# Generate the About dialog
	my $about = Wx::AboutDialogInfo->new;
	$about->SetName( Wx::gettext('YAML Plug-in') );
	my $authors     = 'Zeno Gantner';
	my $description = Wx::gettext( <<'END' );
YAML support for Padre

Copyright 2011 %s
This plug-in is free software; you can redistribute it and/or modify it under the same terms as Padre.
END
	$about->SetDescription( sprintf( $description, $authors ) );

	# Show the About dialog
	Wx::AboutBox($about);

	return;
}

1;


=pod

=head1 NAME

Padre::Plugin::YAML - YAML support for Padre

=head1 VERSION

version 0.01

=head1 DESCRIPTION

YAML support for Padre, the Perl Application Development and Refactoring
Environment.

Syntax highlighting for YAML is supported by Padre out of the box.
This plug-in adds some more features to deal with YAML files.

=head1 AUTHOR

Zeno Gantner <zenog@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2011 by Zeno Gantner.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__END__

