package Faker::Plugin::EsEs::PersonLastName;

use 5.018;

use strict;
use warnings;

use Venus::Class 'base';

base 'Faker::Plugin::EsEs';

# METHODS

sub execute {
  my ($self, $data) = @_;

  return $self->faker->random->select(data_for_last_name());
}

sub data_for_last_name {
  state $last_name = [
    'Abad',
    'Abeyta',
    'Abrego',
    'Abreu',
    'Acevedo',
    'Acosta',
    'Acuña',
    'Adame',
    'Adorno',
    'Agosto',
    'Aguado',
    'Aguayo',
    'Aguilar',
    'Aguilera',
    'Aguirre',
    'Alanis',
    'Alaniz',
    'Alarcón',
    'Alba',
    'Alcala',
    'Alcaráz',
    'Alcántar',
    'Alejandro',
    'Alemán',
    'Alfaro',
    'Alfonso',
    'Alicea',
    'Almanza',
    'Almaráz',
    'Almonte',
    'Alonso',
    'Alonzo',
    'Altamirano',
    'Alva',
    'Alvarado',
    'Álvarez',
    'Amador',
    'Amaya',
    'Anaya',
    'Andreu',
    'Andrés',
    'Anguiano',
    'Angulo',
    'Antón',
    'Aparicio',
    'Apodaca',
    'Aponte',
    'Aragón',
    'Aranda',
    'Araña',
    'Arce',
    'Archuleta',
    'Arellano',
    'Arenas',
    'Arevalo',
    'Arguello',
    'Arias',
    'Armas',
    'Armendáriz',
    'Armenta',
    'Armijo',
    'Arredondo',
    'Arreola',
    'Arriaga',
    'Arribas',
    'Arroyo',
    'Arteaga',
    'Asensio',
    'Atencio',
    'Ávalos',
    'Ávila',
    'Avilés',
    'Ayala',
    'Baca',
    'Badillo',
    'Baeza',
    'Bahena',
    'Balderas',
    'Ballesteros',
    'Banda',
    'Barajas',
    'Barela',
    'Barragán',
    'Barraza',
    'Barrera',
    'Barreto',
    'Barrientos',
    'Barrios',
    'Barroso',
    'Batista',
    'Bautista',
    'Bañuelos',
    'Becerra',
    'Beltrán',
    'Benavides',
    'Benavídez',
    'Benito',
    'Benítez',
    'Bermejo',
    'Bermúdez',
    'Bernal',
    'Berríos',
    'Blanco',
    'Blasco',
    'Blázquez',
    'Bonilla',
    'Borrego',
    'Botello',
    'Bravo',
    'Briones',
    'Briseño',
    'Brito',
    'Bueno',
    'Burgos',
    'Bustamante',
    'Bustos',
    'Báez',
    'Betancourt',
    'Caballero',
    'Cabello',
    'Cabrera',
    'Cabán',
    'Cadena',
    'Caldera',
    'Calderón',
    'Calero',
    'Calvillo',
    'Calvo',
    'Camacho',
    'Camarillo',
    'Campos',
    'Canales',
    'Candelaria',
    'Cano',
    'Cantú',
    'Caraballo',
    'Carbajal',
    'Carballo',
    'Carbonell',
    'Cárdenas',
    'Cardona',
    'Carmona',
    'Caro',
    'Carranza',
    'Carrasco',
    'Carrasquillo',
    'Carrera',
    'Carrero',
    'Carretero',
    'Carreón',
    'Carrillo',
    'Carrión',
    'Carvajal',
    'Casado',
    'Casanova',
    'Casares',
    'Casas',
    'Casillas',
    'Castañeda',
    'Castaño',
    'Castellano',
    'Castellanos',
    'Castillo',
    'Castro',
    'Casárez',
    'Cavazos',
    'Cazares',
    'Ceballos',
    'Cedillo',
    'Ceja',
    'Centeno',
    'Cepeda',
    'Cerda',
    'Cervantes',
    'Cervántez',
    'Chacón',
    'Chapa',
    'Chavarría',
    'Chávez',
    'Cintrón',
    'Cisneros',
    'Clemente',
    'Cobo',
    'Collado',
    'Collazo',
    'Colunga',
    'Colón',
    'Concepción',
    'Conde',
    'Contreras',
    'Cordero',
    'Cornejo',
    'Corona',
    'Coronado',
    'Corral',
    'Corrales',
    'Correa',
    'Cortés',
    'Cortez',
    'Cortés',
    'Costa',
    'Cotto',
    'Covarrubias',
    'Crespo',
    'Cruz',
    'Cuellar',
    'Cuenca',
    'Cuesta',
    'Cuevas',
    'Curiel',
    'Córdoba',
    'Córdova',
    'De Anda',
    'De Jesús',
    'De la Cruz',
    'De la Fuente',
    'De la Torre',
    'Del Río',
    'Delacrúz',
    'Delafuente',
    'Delagarza',
    'Delao',
    'Delapaz',
    'Delarosa',
    'Delatorre',
    'Deleón',
    'Delgadillo',
    'Delgado',
    'Delrío',
    'Delvalle',
    'Díez',
    'Domenech',
    'Domingo',
    'Domínguez',
    'Domínquez',
    'Duarte',
    'Dueñas',
    'Duran',
    'Dávila',
    'Díaz',
    'Echevarría',
    'Elizondo',
    'Enríquez',
    'Escalante',
    'Escamilla',
    'Escobar',
    'Escobedo',
    'Escribano',
    'Escudero',
    'Esparza',
    'Espinal',
    'Espino',
    'Espinosa',
    'Espinoza',
    'Esquibel',
    'Esquivel',
    'Esteban',
    'Esteve',
    'Estrada',
    'Estévez',
    'Expósito',
    'Fajardo',
    'Farías',
    'Feliciano',
    'Fernández',
    'Ferrer',
    'Fierro',
    'Figueroa',
    'Flores',
    'Flórez',
    'Fonseca',
    'Font',
    'Franco',
    'Frías',
    'Fuentes',
    'Gaitán',
    'Galarza',
    'Galindo',
    'Gallardo',
    'Gallego',
    'Gallegos',
    'Galván',
    'Galán',
    'Gamboa',
    'Gámez',
    'Gaona',
    'Garay',
    'García',
    'Garibay',
    'Garica',
    'Garrido',
    'Garza',
    'Gastélum',
    'Gaytán',
    'Gil',
    'Gimeno',
    'Giménez',
    'Girón',
    'Godoy',
    'Godínez',
    'Gonzáles',
    'González',
    'Gracia',
    'Granado',
    'Granados',
    'Griego',
    'Grijalva',
    'Guajardo',
    'Guardado',
    'Guerra',
    'Guerrero',
    'Guevara',
    'Guillen',
    'Gurule',
    'Gutiérrez',
    'Guzmán',
    'Gálvez',
    'Gómez',
    'Haro',
    'Henríquez',
    'Heredia',
    'Hernándes',
    'Hernando',
    'Hernádez',
    'Hernández',
    'Herrera',
    'Herrero',
    'Hidalgo',
    'Hinojosa',
    'Holguín',
    'Huerta',
    'Hurtado',
    'Ibarra',
    'Ibáñez',
    'Iglesias',
    'Irizarry',
    'Izquierdo',
    'Jaime',
    'Jaimes',
    'Jaramillo',
    'Jasso',
    'Jiménez',
    'Jimínez',
    'Juan',
    'Jurado',
    'Juárez',
    'Jáquez',
    'Laboy',
    'Lara',
    'Laureano',
    'Leal',
    'Lebrón',
    'Ledesma',
    'Leiva',
    'Lemus',
    'Lerma',
    'Leyva',
    'León',
    'Limón',
    'Linares',
    'Lira',
    'Llamas',
    'Llorente',
    'Loera',
    'Lomeli',
    'Longoria',
    'Lorente',
    'Lorenzo',
    'Lovato',
    'Loya',
    'Lozada',
    'Lozano',
    'Lucas',
    'Lucero',
    'Lucio',
    'Luevano',
    'Lugo',
    'Luis',
    'Luján',
    'Luna',
    'Luque',
    'Lázaro',
    'López',
    'Macias',
    'Macías',
    'Madera',
    'Madrid',
    'Madrigal',
    'Maestas',
    'Magaña',
    'Malave',
    'Maldonado',
    'Manzanares',
    'Manzano',
    'Marco',
    'Marcos',
    'Mares',
    'Marrero',
    'Marroquín',
    'Martos',
    'Martí',
    'Martín',
    'Martínez',
    'Marín',
    'Más',
    'Mascareñas',
    'Mata',
    'Mateo',
    'Mateos',
    'Matos',
    'Matías',
    'Maya',
    'Mayorga',
    'Medina',
    'Medrano',
    'Mejía',
    'Melgar',
    'Meléndez',
    'Mena',
    'Menchaca',
    'Mendoza',
    'Menéndez',
    'Meraz',
    'Mercado',
    'Merino',
    'Mesa',
    'Meza',
    'Miguel',
    'Millán',
    'Miramontes',
    'Miranda',
    'Mireles',
    'Mojica',
    'Molina',
    'Mondragón',
    'Monroy',
    'Montalvo',
    'Montañez',
    'Montaño',
    'Montemayor',
    'Montenegro',
    'Montero',
    'Montes',
    'Montez',
    'Montoya',
    'Mora',
    'Moral',
    'Morales',
    'Morán',
    'Moreno',
    'Mota',
    'Moya',
    'Munguía',
    'Murillo',
    'Muro',
    'Muñiz',
    'Muñoz',
    'Márquez',
    'Méndez',
    'Naranjo',
    'Narváez',
    'Nava',
    'Navarrete',
    'Navarro',
    'Navas',
    'Nazario',
    'Negrete',
    'Negrón',
    'Nevárez',
    'Nieto',
    'Nieves',
    'Niño',
    'Noriega',
    'Nájera',
    'Núñez',
    'Ocampo',
    'Ocasio',
    'Ochoa',
    'Ojeda',
    'Oliva',
    'Olivares',
    'Olivas',
    'Oliver',
    'Olivera',
    'Olivo',
    'Olivárez',
    'Olmos',
    'Olvera',
    'Ontiveros',
    'Oquendo',
    'Ordoñez',
    'Ordóñez',
    'Orellana',
    'Ornelas',
    'Orosco',
    'Orozco',
    'Orta',
    'Ortega',
    'Ortíz',
    'Osorio',
    'Otero',
    'Ozuna',
    'Pabón',
    'Pacheco',
    'Padilla',
    'Padrón',
    'Pagan',
    'Palacios',
    'Palomino',
    'Palomo',
    'Pantoja',
    'Pardo',
    'Paredes',
    'Parra',
    'Partida',
    'Pascual',
    'Pastor',
    'Patiño',
    'Paz',
    'Pedraza',
    'Pedroza',
    'Pelayo',
    'Peláez',
    'Perales',
    'Peralta',
    'Perea',
    'Pereira',
    'Peres',
    'Peña',
    'Pichardo',
    'Pineda',
    'Pizarro',
    'Piña',
    'Piñeiro',
    'Plaza',
    'Polanco',
    'Polo',
    'Ponce',
    'Pons',
    'Porras',
    'Portillo',
    'Posada',
    'Pozo',
    'Prado',
    'Preciado',
    'Prieto',
    'Puente',
    'Puga',
    'Puig',
    'Pulido',
    'Páez',
    'Pérez',
    'Quesada',
    'Quezada',
    'Quintana',
    'Quintanilla',
    'Quintero',
    'Quiroz',
    'Quiñones',
    'Quiñónez',
    'Rael',
    'Ramos',
    'Ramírez',
    'Ramón',
    'Rangel',
    'Rascón',
    'Raya',
    'Razo',
    'Redondo',
    'Regalado',
    'Reina',
    'Rendón',
    'Rentería',
    'Requena',
    'Reséndez',
    'Rey',
    'Reyes',
    'Reyna',
    'Reynoso',
    'Rico',
    'Riera',
    'Rincón',
    'Riojas',
    'Rivas',
    'Rivera',
    'Rivero',
    'Robledo',
    'Robles',
    'Roca',
    'Rocha',
    'Rodarte',
    'Rodrigo',
    'Rodríguez',
    'Rodríquez',
    'Roig',
    'Rojas',
    'Rojo',
    'Roldán',
    'Rolón',
    'Romero',
    'Romo',
    'Román',
    'Roque',
    'Ros',
    'Rosa',
    'Rosado',
    'Rosales',
    'Rosario',
    'Rosas',
    'Roybal',
    'Rubio',
    'Rueda',
    'Ruelas',
    'Ruiz',
    'Ruvalcaba',
    'Ruíz',
    'Ríos',
    'Saavedra',
    'Saiz',
    'Salas',
    'Salazar',
    'Salcedo',
    'Salcido',
    'Saldaña',
    'Saldivar',
    'Salgado',
    'Salinas',
    'Salvador',
    'Samaniego',
    'Sanabria',
    'Sánchez',
    'Sancho',
    'Sandoval',
    'Santacruz',
    'Santamaría',
    'Santana',
    'Santiago',
    'Santillán',
    'Santos',
    'Sanz',
    'Sarabia',
    'Sauceda',
    'Saucedo',
    'Sedillo',
    'Segovia',
    'Segura',
    'Sepúlveda',
    'Serna',
    'Serra',
    'Serrano',
    'Serrato',
    'Sevilla',
    'Sierra',
    'Silva',
    'Simón',
    'Sisneros',
    'Sola',
    'Solano',
    'Soler',
    'Soliz',
    'Solorio',
    'Solorzano',
    'Solís',
    'Soria',
    'Soriano',
    'Sosa',
    'Sotelo',
    'Soto',
    'Suárez',
    'Sáenz',
    'Sáez',
    'Sánchez',
    'Tafoya',
    'Tamayo',
    'Tamez',
    'Tapia',
    'Tejada',
    'Tejeda',
    'Tello',
    'Terrazas',
    'Terán',
    'Tijerina',
    'Tirado',
    'Toledo',
    'Toro',
    'Torres',
    'Tovar',
    'Trejo',
    'Treviño',
    'Trujillo',
    'Téllez',
    'Tórrez',
    'Ulibarri',
    'Ulloa',
    'Urbina',
    'Ureña',
    'Uribe',
    'Urrutia',
    'Urías',
    'Vaca',
    'Valadez',
    'Valdez',
    'Valdivia',
    'Valdés',
    'Valencia',
    'Valentín',
    'Valenzuela',
    'Valero',
    'Valladares',
    'Valle',
    'Vallejo',
    'Valles',
    'Valverde',
    'Vanegas',
    'Varela',
    'Vargas',
    'Vega',
    'Vela',
    'Velasco',
    'Velásquez',
    'Velázquez',
    'Venegas',
    'Vera',
    'Verdugo',
    'Verduzco',
    'Vergara',
    'Vicente',
    'Vidal',
    'Viera',
    'Vigil',
    'Vila',
    'Villa',
    'Villagómez',
    'Villalba',
    'Villalobos',
    'Villalpando',
    'Villanueva',
    'Villar',
    'Villareal',
    'Villarreal',
    'Villaseñor',
    'Villegas',
    'Vásquez',
    'Vázquez',
    'Vélez',
    'Véliz',
    'Ybarra',
    'Yáñez',
    'Zambrano',
    'Zamora',
    'Zamudio',
    'Zapata',
    'Zaragoza',
    'Zarate',
    'Zavala',
    'Zayas',
    'Zelaya',
    'Zepeda',
    'Zúñiga',
  ]
}

1;



=head1 NAME

Faker::Plugin::EsEs::PersonLastName - Person Last Name

=cut

=head1 ABSTRACT

Person Last Name for Faker

=cut

=head1 SYNOPSIS

  package main;

  use Faker::Plugin::EsEs::PersonLastName;

  my $plugin = Faker::Plugin::EsEs::PersonLastName->new;

  # bless(..., "Faker::Plugin::EsEs::PersonLastName")

=cut

=head1 DESCRIPTION

This package provides methods for generating fake data for person last name.

=encoding utf8

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Faker::Plugin::EsEs>

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 execute

  execute(HashRef $data) (Str)

The execute method returns a returns a random fake person last name.

I<Since C<1.10>>

=over 4

=item execute example 1

  package main;

  use Faker::Plugin::EsEs::PersonLastName;

  my $plugin = Faker::Plugin::EsEs::PersonLastName->new;

  # bless(..., "Faker::Plugin::EsEs::PersonLastName")

  # my $result = $plugin->execute;

  # 'Expósito';

  # my $result = $plugin->execute;

  # 'Heredia';

  # my $result = $plugin->execute;

  # 'Serrato';

=back

=cut

=head2 new

  new(HashRef $data) (Plugin)

The new method returns a new instance of the class.

I<Since C<1.10>>

=over 4

=item new example 1

  package main;

  use Faker::Plugin::EsEs::PersonLastName;

  my $plugin = Faker::Plugin::EsEs::PersonLastName->new;

  # bless(..., "Faker::Plugin::EsEs::PersonLastName")

=back

=cut