# Generated by default/object.tt
package Paws::CloudFormation::TypeFilters;
  use Moose;
  has Category => (is => 'ro', isa => 'Str');
  has PublisherId => (is => 'ro', isa => 'Str');
  has TypeNamePrefix => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFormation::TypeFilters

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFormation::TypeFilters object:

  $service_obj->Method(Att1 => { Category => $value, ..., TypeNamePrefix => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFormation::TypeFilters object:

  $result = $service_obj->Method(...);
  $result->Att1->Category

=head1 DESCRIPTION

Filter criteria to use in determining which extensions to return.

=head1 ATTRIBUTES


=head2 Category => Str

The category of extensions to return.

=over

=item *

C<REGISTERED>: Private extensions that have been registered for this
account and region.

=item *

C<ACTIVATED>: Public extensions that have been activated for this
account and region.

=item *

C<THIRD-PARTY>: Extensions available for use from publishers other than
Amazon. This includes:

=over

=item *

Private extensions registered in the account.

=item *

Public extensions from publishers other than Amazon, whether activated
or not.

=back

=item *

C<AWS-TYPES>: Extensions available for use from Amazon.

=back



=head2 PublisherId => Str

The id of the publisher of the extension.

Extensions published by Amazon are not assigned a publisher ID. Use the
C<AWS-TYPES> category to specify a list of types published by Amazon.


=head2 TypeNamePrefix => Str

A prefix to use as a filter for results.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

