# Dell Latitude E7240

This page is about the notebook [Dell Latitude E7240].

## Release status

Dell Latitude E7240 was released in 2013 and is now end of life.
It can be bought from a secondhand market like Taobao or eBay.

## Required proprietary blobs

The following blobs are required to operate the hardware:
1. mrc.bin
2. Intel ME firmware

Memory reference code in mrc.bin is used to initialize the Haswell platform.
You need this blob to build a working coreboot image. Please read
[mrc.bin](../../northbridge/intel/haswell/mrc.bin) for instructions on
retrieving and using it.

Intel ME firmware is in the flash chip. It is not needed when building coreboot.
It can be extracted from the OEM firmware. You can also flash only the BIOS
region to leave Intel ME firmware untouched.

## Programming

The laptop can be flashed internally under OEM firmware using [dell-flash-unlock].

To flash with an external programmer, you need to remove the battery and the base cover.

![Dell Latitude E7240 mainboard](e7240.webp)

For more details have a look at the general [flashing tutorial].

It is also possible to flash internally under coreboot.

## Debugging

The board can be debugged with EHCI debug. The EHCI debug port is next to the miniDP port.

There's a serial port on dock, but it's not yet supported in coreboot.

Schematic of this laptop can be found online. The board name is Compal LA-9431P.

## Test status

### Not working

- EC ACPI
- SD/MMC card reader (kernel reports "Timeout waiting for hardware cmd interrupt.")
- No internal display before booting to OS when connected with a dock

### Working

- Integrated graphics init with libgfxinit
- mSATA
- WLAN
- USB
- Keyboard
- Touchpad and the buttons on it
- Dock: all USB ports, DisplayPort, eSATA
- Internal flashing


## Technology

```{eval-rst}
+------------------+-----------------------------+
| CPU              | Intel Haswell-ULT           |
+------------------+-----------------------------+
| PCH              | Intel Lynx Point Low Power  |
+------------------+-----------------------------+
| EC               | SMSC MEC5075                |
+------------------+-----------------------------+
| Super I/O        | SMSC ECE5048                |
+------------------+-----------------------------+
| Coprocessor      | Intel Management Engine     |
+------------------+-----------------------------+
```

[Dell Latitude E7240]: https://www.dell.com/support/home/en-us/product-support/product/latitude-e7240-ultrabook/docs
[dell-flash-unlock]: https://github.com/nic3-14159/dell-flash-unlock
[flashing tutorial]: ../../tutorial/flashing_firmware/ext_power.md
