/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

// InactivePropertyHelper `align-content` test cases.

export default [
  {
    info: "margin is active on block containers",
    property: "margin",
    tagName: "div",
    rules: ["div { margin: 10px; }"],
    isActive: true,
  },
  {
    info: "margin is active on flex containers",
    property: "margin",
    tagName: "div",
    rules: ["div { display: flex; margin: 10px; }"],
    isActive: true,
  },
  {
    info: "margin is active on grid containers",
    property: "margin",
    tagName: "div",
    rules: ["div { display: grid; margin: 10px; }"],
    isActive: true,
  },
  {
    info: "margin is active on tables",
    property: "margin",
    tagName: "div",
    rules: ["div { display: table; margin: 10px; }"],
    isActive: true,
  },
  {
    info: "margin is active on inline tables",
    property: "margin",
    tagName: "div",
    rules: ["div { display: inline-table; margin: 10px; }"],
    isActive: true,
  },
  {
    info: "margin is active on table captions",
    property: "margin",
    tagName: "div",
    rules: ["div { display: table-caption; margin: 10px; }"],
    isActive: true,
  },
  {
    info: "margin is inactive on table cells",
    property: "margin",
    tagName: "div",
    rules: ["div { display: table-cell; margin: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-block is inactive on table cells",
    property: "margin-block",
    tagName: "div",
    rules: ["div { display: table-cell; margin-block: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-block-start is inactive on table cells",
    property: "margin-block-start",
    tagName: "div",
    rules: ["div { display: table-cell; margin-block-start: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-block-end is inactive on table cells",
    property: "margin-block-end",
    tagName: "div",
    rules: ["div { display: table-cell; margin-block-end: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-block is inactive on table cells",
    property: "margin-block",
    tagName: "div",
    rules: ["div { display: table-cell; margin-block: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-bottom is inactive on table rows",
    property: "margin-bottom",
    tagName: "div",
    rules: ["div { display: table-row; margin-bottom: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-inline-start is inactive on table rows",
    property: "margin-inline-start",
    tagName: "div",
    rules: ["div { display: table-row; margin-inline-start: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-inline-end is inactive on table rows",
    property: "margin-inline-end",
    tagName: "div",
    rules: ["div { display: table-row; margin-inline-end: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-inline is inactive on table rows",
    property: "margin-inline",
    tagName: "div",
    rules: ["div { display: table-row; margin-inline: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-left is inactive on table columns",
    property: "margin-left",
    tagName: "div",
    rules: ["div { display: table-column; margin-left: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-right is inactive on table row groups",
    property: "margin-right",
    tagName: "div",
    rules: ["div { display: table-row-group; margin-right: 10px; }"],
    isActive: false,
  },
  {
    info: "margin-top is inactive on table column groups",
    property: "margin-top",
    tagName: "div",
    rules: ["div { display: table-column-group; margin-top: 10px; }"],
    isActive: false,
  },
  {
    info: "padding is active on block containers",
    property: "padding",
    tagName: "div",
    rules: ["div { padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding is active on flex containers",
    property: "padding",
    tagName: "div",
    rules: ["div { display: flex; padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding is active on grid containers",
    property: "padding",
    tagName: "div",
    rules: ["div { display: grid; padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding is active on tables",
    property: "padding",
    tagName: "div",
    rules: ["div { display: table; padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding is active on inline tables",
    property: "padding",
    tagName: "div",
    rules: ["div { display: inline-table; padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding is active on table captions",
    property: "padding",
    tagName: "div",
    rules: ["div { display: table-caption; padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding is active on table cells",
    property: "padding",
    tagName: "div",
    rules: ["div { display: table-cell; padding: 10px; }"],
    isActive: true,
  },
  {
    info: "padding-block is active on table cells",
    property: "padding-block",
    tagName: "div",
    rules: ["div { display: table-cell; padding-block: 10px; }"],
    isActive: true,
  },
  {
    info: "padding-block-start is active on table cells",
    property: "padding-block-start",
    tagName: "div",
    rules: ["div { display: table-cell; padding-block-start: 10px; }"],
    isActive: true,
  },
  {
    info: "padding-block-end is active on table cells",
    property: "padding-block-end",
    tagName: "div",
    rules: ["div { display: table-cell; padding-block-end: 10px; }"],
    isActive: true,
  },
  {
    info: "padding-block is active on table cells",
    property: "padding-block",
    tagName: "div",
    rules: ["div { display: table-cell; padding-block: 10px; }"],
    isActive: true,
  },
  {
    info: "padding-bottom is inactive on table rows",
    property: "padding-bottom",
    tagName: "div",
    rules: ["div { display: table-row; padding-bottom: 10px; }"],
    isActive: false,
  },
  {
    info: "padding-inline-start is inactive on table rows",
    property: "padding-inline-start",
    tagName: "div",
    rules: ["div { display: table-row; padding-inline-start: 10px; }"],
    isActive: false,
  },
  {
    info: "padding-inline-end is inactive on table rows",
    property: "padding-inline-end",
    tagName: "div",
    rules: ["div { display: table-row; padding-inline-end: 10px; }"],
    isActive: false,
  },
  {
    info: "padding-inline is inactive on table rows",
    property: "padding-inline",
    tagName: "div",
    rules: ["div { display: table-row; padding-inline: 10px; }"],
    isActive: false,
  },
  {
    info: "padding-left is inactive on table columns",
    property: "padding-left",
    tagName: "div",
    rules: ["div { display: table-column; padding-left: 10px; }"],
    isActive: false,
  },
  {
    info: "padding-right is inactive on table row groups",
    property: "padding-right",
    tagName: "div",
    rules: ["div { display: table-row-group; padding-right: 10px; }"],
    isActive: false,
  },
  {
    info: "padding-top is inactive on table column groups",
    property: "padding-top",
    tagName: "div",
    rules: ["div { display: table-column-group; padding-top: 10px; }"],
    isActive: false,
  },
];
