
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file PostScriptDriverAttributes.h
    \\brief Definition of PostScriptDriver Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "PostScriptDriverAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

PostScriptDriverAttributes::PostScriptDriverAttributes():
	colour_model_(ParameterManager::getString("output_ps_colour_model")),
	scale_(ParameterManager::getDouble("output_ps_scale")),
	split_(ParameterManager::getBool("output_ps_split"))
	
	
{
}


PostScriptDriverAttributes::~PostScriptDriverAttributes()
{

}


void PostScriptDriverAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(2);
	int i = 0;
	prefix[i++] = "output_ps";
	prefix[i++] = "output";
	
	setAttribute(prefix, "output_ps_colour_model", colour_model_, params);
	setAttribute(prefix, "output_ps_scale", scale_, params);
	setAttribute(prefix, "output_ps_split", split_, params);
	
	
}

void PostScriptDriverAttributes::copy(const PostScriptDriverAttributes& other)
{
	colour_model_ = other.colour_model_;
	scale_ = other.scale_;
	split_ = other.split_;
	
}


bool PostScriptDriverAttributes::accept(const string& node)
{

	if ( magCompare(node, "ps")  )
		return true;
	
	return false;
}

void PostScriptDriverAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "ps")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		
	}
	for (auto &elt : node.elements())
	{
		
	}
}

void PostScriptDriverAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " colour_model = " <<  colour_model_;
	out << " scale = " <<  scale_;
	out << " split = " <<  split_;
	
	out << "]" << "\n";
}

void PostScriptDriverAttributes::toxml(ostream& out)  const
{
	out <<  "\"ps\"";
	out << ", \"output_ps_colour_model\":";
	niceprint(out,colour_model_);
	out << ", \"output_ps_scale\":";
	niceprint(out,scale_);
	out << ", \"output_ps_split\":";
	niceprint(out,split_);
	
}

static MagicsParameter<string> output_ps_colour_model("output_ps_colour_model", "rgb");
static MagicsParameter<double> output_ps_scale("output_ps_scale", 1.0);
static MagicsParameter<string> output_ps_split("output_ps_split", "off");
