# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservices.aio import RecoveryServicesClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestRecoveryServicesVaultsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(RecoveryServicesClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vaults_get(self, resource_group):
        response = await self.client.vaults.get(
            resource_group_name=resource_group.name,
            vault_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vaults_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.vaults.begin_create_or_update(
                resource_group_name=resource_group.name,
                vault_name="str",
                vault={
                    "location": "str",
                    "etag": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "properties": {
                        "backupStorageVersion": "str",
                        "bcdrSecurityLevel": "str",
                        "encryption": {
                            "infrastructureEncryption": "str",
                            "kekIdentity": {"useSystemAssignedIdentity": bool, "userAssignedIdentity": "str"},
                            "keyVaultProperties": {"keyUri": "str"},
                        },
                        "monitoringSettings": {
                            "azureMonitorAlertSettings": {
                                "alertsForAllFailoverIssues": "str",
                                "alertsForAllJobFailures": "str",
                                "alertsForAllReplicationIssues": "str",
                            },
                            "classicAlertSettings": {
                                "alertsForCriticalOperations": "str",
                                "emailNotificationsForSiteRecovery": "str",
                            },
                        },
                        "moveDetails": {
                            "completionTimeUtc": "2020-02-20 00:00:00",
                            "operationId": "str",
                            "sourceResourceId": "str",
                            "startTimeUtc": "2020-02-20 00:00:00",
                            "targetResourceId": "str",
                        },
                        "moveState": "str",
                        "privateEndpointConnections": [
                            {
                                "id": "str",
                                "location": "str",
                                "name": "str",
                                "properties": {
                                    "groupIds": ["str"],
                                    "privateEndpoint": {"id": "str"},
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",
                                        "description": "str",
                                        "status": "str",
                                    },
                                    "provisioningState": "str",
                                },
                                "type": "str",
                            }
                        ],
                        "privateEndpointStateForBackup": "str",
                        "privateEndpointStateForSiteRecovery": "str",
                        "provisioningState": "str",
                        "publicNetworkAccess": "str",
                        "redundancySettings": {"crossRegionRestore": "str", "standardTierStorageRedundancy": "str"},
                        "resourceGuardOperationRequests": ["str"],
                        "restoreSettings": {
                            "crossSubscriptionRestoreSettings": {"crossSubscriptionRestoreState": "str"}
                        },
                        "secureScore": "str",
                        "securitySettings": {
                            "immutabilitySettings": {"state": "str"},
                            "multiUserAuthorization": "str",
                            "softDeleteSettings": {
                                "enhancedSecurityState": "str",
                                "softDeleteRetentionPeriodInDays": 0,
                                "softDeleteState": "str",
                            },
                            "sourceScanConfiguration": {
                                "sourceScanIdentity": {"operationIdentityType": "str", "userAssignedIdentity": "str"},
                                "state": "str",
                            },
                        },
                        "upgradeDetails": {
                            "endTimeUtc": "2020-02-20 00:00:00",
                            "lastUpdatedTimeUtc": "2020-02-20 00:00:00",
                            "message": "str",
                            "operationId": "str",
                            "previousResourceId": "str",
                            "startTimeUtc": "2020-02-20 00:00:00",
                            "status": "str",
                            "triggerType": "str",
                            "upgradedResourceId": "str",
                        },
                    },
                    "sku": {"name": "str", "capacity": "str", "family": "str", "size": "str", "tier": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vaults_begin_update(self, resource_group):
        response = await (
            await self.client.vaults.begin_update(
                resource_group_name=resource_group.name,
                vault_name="str",
                vault={
                    "etag": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "location": "str",
                    "name": "str",
                    "properties": {
                        "backupStorageVersion": "str",
                        "bcdrSecurityLevel": "str",
                        "encryption": {
                            "infrastructureEncryption": "str",
                            "kekIdentity": {"useSystemAssignedIdentity": bool, "userAssignedIdentity": "str"},
                            "keyVaultProperties": {"keyUri": "str"},
                        },
                        "monitoringSettings": {
                            "azureMonitorAlertSettings": {
                                "alertsForAllFailoverIssues": "str",
                                "alertsForAllJobFailures": "str",
                                "alertsForAllReplicationIssues": "str",
                            },
                            "classicAlertSettings": {
                                "alertsForCriticalOperations": "str",
                                "emailNotificationsForSiteRecovery": "str",
                            },
                        },
                        "moveDetails": {
                            "completionTimeUtc": "2020-02-20 00:00:00",
                            "operationId": "str",
                            "sourceResourceId": "str",
                            "startTimeUtc": "2020-02-20 00:00:00",
                            "targetResourceId": "str",
                        },
                        "moveState": "str",
                        "privateEndpointConnections": [
                            {
                                "id": "str",
                                "location": "str",
                                "name": "str",
                                "properties": {
                                    "groupIds": ["str"],
                                    "privateEndpoint": {"id": "str"},
                                    "privateLinkServiceConnectionState": {
                                        "actionsRequired": "str",
                                        "description": "str",
                                        "status": "str",
                                    },
                                    "provisioningState": "str",
                                },
                                "type": "str",
                            }
                        ],
                        "privateEndpointStateForBackup": "str",
                        "privateEndpointStateForSiteRecovery": "str",
                        "provisioningState": "str",
                        "publicNetworkAccess": "str",
                        "redundancySettings": {"crossRegionRestore": "str", "standardTierStorageRedundancy": "str"},
                        "resourceGuardOperationRequests": ["str"],
                        "restoreSettings": {
                            "crossSubscriptionRestoreSettings": {"crossSubscriptionRestoreState": "str"}
                        },
                        "secureScore": "str",
                        "securitySettings": {
                            "immutabilitySettings": {"state": "str"},
                            "multiUserAuthorization": "str",
                            "softDeleteSettings": {
                                "enhancedSecurityState": "str",
                                "softDeleteRetentionPeriodInDays": 0,
                                "softDeleteState": "str",
                            },
                            "sourceScanConfiguration": {
                                "sourceScanIdentity": {"operationIdentityType": "str", "userAssignedIdentity": "str"},
                                "state": "str",
                            },
                        },
                        "upgradeDetails": {
                            "endTimeUtc": "2020-02-20 00:00:00",
                            "lastUpdatedTimeUtc": "2020-02-20 00:00:00",
                            "message": "str",
                            "operationId": "str",
                            "previousResourceId": "str",
                            "startTimeUtc": "2020-02-20 00:00:00",
                            "status": "str",
                            "triggerType": "str",
                            "upgradedResourceId": "str",
                        },
                    },
                    "sku": {"name": "str", "capacity": "str", "family": "str", "size": "str", "tier": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vaults_begin_delete(self, resource_group):
        response = await (
            await self.client.vaults.begin_delete(
                resource_group_name=resource_group.name,
                vault_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vaults_list_by_subscription_id(self, resource_group):
        response = self.client.vaults.list_by_subscription_id()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_vaults_list_by_resource_group(self, resource_group):
        response = self.client.vaults.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
