/* SPDX-License-Identifier: BSD-3-Clause */
/*
 * Altera SoCFPGA IOCSR configuration
 */

#ifndef __SOCFPGA_IOCSR_CONFIG_H__
#define __SOCFPGA_IOCSR_CONFIG_H__

#define CONFIG_HPS_IOCSR_SCANCHAIN0_LENGTH	1337
#define CONFIG_HPS_IOCSR_SCANCHAIN1_LENGTH	1719
#define CONFIG_HPS_IOCSR_SCANCHAIN2_LENGTH	1528
#define CONFIG_HPS_IOCSR_SCANCHAIN3_LENGTH	16766

const unsigned long iocsr_scan_chain0_table[] = {
	0x00100000,
	0x40000000,
	0x00000000,
	0x00000100,
	0x00040000,
	0x00008000,
	0x00080000,
	0x20000000,
	0x00000000,
	0x00000080,
	0x00020000,
	0x00004000,
	0x00040000,
	0x10000000,
	0x00000000,
	0x00000040,
	0x00010000,
	0x00002000,
	0x00000000,
	0x00000000,
	0x00000000,
	0x00000020,
	0x00008000,
	0x00001000,
	0x00000000,
	0x0300C000,
	0x0000000C,
	0x00000000,
	0x00000000,
	0x00000800,
	0x01806018,
	0x00000000,
	0x01800000,
	0x00001806,
	0x00001806,
	0x00000400,
	0x00C0300C,
	0x00C03000,
	0x00C00003,
	0x00000C03,
	0x00300C03,
	0x00000200,
};

const unsigned long iocsr_scan_chain1_table[] = {
	0x00100000,
	0x40000000,
	0x00000000,
	0x00000100,
	0x00040000,
	0x00008000,
	0x00060180,
	0x18060000,
	0x00000000,
	0x00000080,
	0x00020000,
	0x00004000,
	0x00040000,
	0x10000000,
	0x00000000,
	0x00000040,
	0x00010000,
	0x00002000,
	0x00020000,
	0x08000000,
	0x01FE0000,
	0xF8000000,
	0x00000007,
	0x00001000,
	0x00010000,
	0x04000000,
	0x00000000,
	0x00000010,
	0x00004000,
	0x00000800,
	0x00006018,
	0x01806000,
	0x00000006,
	0x00000008,
	0x00601806,
	0x00000400,
	0x0000300C,
	0x00C03000,
	0x00C00000,
	0x00000003,
	0x00000C03,
	0x00000200,
	0x00000000,
	0x00601800,
	0x80600000,
	0x80000001,
	0x00000601,
	0x00000100,
	0x00300C03,
	0xC0300C00,
	0xC0300000,
	0xC0000300,
	0x000C0300,
	0x00000080,
};

const unsigned long iocsr_scan_chain2_table[] = {
	0x00100000,
	0x40000000,
	0x00000000,
	0x00000100,
	0x00040000,
	0x00008000,
	0x00080000,
	0x20000000,
	0x00000000,
	0x00000080,
	0x00020000,
	0x00004000,
	0x00040000,
	0x10000000,
	0x00000000,
	0x00000040,
	0x00010000,
	0x00002000,
	0x00018060,
	0x08000000,
	0x00000000,
	0x00000020,
	0x00008000,
	0x00001000,
	0x0300C030,
	0x00000000,
	0x03000000,
	0x0000000C,
	0x00C0300C,
	0x00000800,
	0x01806018,
	0x01806000,
	0x00000006,
	0x00000000,
	0x00601806,
	0x00000400,
	0x00C0300C,
	0x00C03000,
	0x00C00003,
	0x00000C03,
	0x00300C03,
	0x00000200,
	0x00601806,
	0x80601800,
	0x80600001,
	0x80000601,
	0x00180601,
	0x00000100,
};

const unsigned long iocsr_scan_chain3_table[] = {
	0x2CC20D80,
	0x082000FF,
	0x08028001,
	0x00100000,
	0x08020000,
	0x00100000,
	0x0A800000,
	0x07900000,
	0x08020000,
	0x00100000,
	0x00000000,
	0xC0000010,
	0x00C00512,
	0x00000000,
	0x00000021,
	0x82000004,
	0x05400000,
	0x03C80000,
	0x04010000,
	0x00080000,
	0x05400000,
	0x03C80000,
	0x05400000,
	0x03C80000,
	0xA2580000,
	0x60001800,
	0x00600289,
	0x800A2580,
	0x00000001,
	0x40000002,
	0x02A00000,
	0x01E40000,
	0x02A00000,
	0x01E40000,
	0x02A00000,
	0x01E40000,
	0x02A00000,
	0x01E40000,
	0x512C0000,
	0xB0000C00,
	0x00300144,
	0xC00512C0,
	0x144B0000,
	0x20000300,
	0x00040000,
	0x50670000,
	0x00000050,
	0x24590000,
	0x00001000,
	0xA0000034,
	0x0D000001,
	0xA0680514,
	0xC3034028,
	0x06181A00,
	0x805140D0,
	0x34069A06,
	0x01A034D0,
	0x240D0000,
	0x28A06809,
	0x00000340,
	0xD000001A,
	0x06809240,
	0x10040000,
	0x00200000,
	0x10040000,
	0x00200000,
	0x15000000,
	0x0F200000,
	0x15000000,
	0x0F200000,
	0x01FE0000,
	0x80000000,
	0x01800A25,
	0x00289600,
	0x007F8006,
	0x00000000,
	0x0A800001,
	0x07900000,
	0x0A800000,
	0x07900000,
	0x0A800000,
	0x07900000,
	0x08020000,
	0x00100000,
	0x44B00000,
	0xC0003001,
	0x00C00512,
	0x00000FF0,
	0x512C0000,
	0x80000C00,
	0x05400000,
	0x02480000,
	0x04000000,
	0x00080000,
	0x05400000,
	0x03C80000,
	0x05400000,
	0x03C80000,
	0x581D8000,
	0x60001800,
	0x00600289,
	0x800A2580,
	0x16076001,
	0x40000600,
	0x02A00040,
	0x01E40000,
	0x02A00000,
	0x01E40000,
	0x02A00000,
	0x01E40000,
	0x02A00000,
	0x01E40000,
	0x512C0000,
	0xB0000C00,
	0x00300144,
	0xC00512C0,
	0x144B0000,
	0x20000300,
	0x00040000,
	0x50670000,
	0x00000050,
	0x24590000,
	0x00001000,
	0xA0000034,
	0x0D000001,
	0xA0680514,
	0x4D034028,
	0x1A681A03,
	0x805140D0,
	0x34069A06,
	0x01A00020,
	0x240D0001,
	0x49206809,
	0x034D0340,
	0xD01A681A,
	0x06805140,
	0x10040000,
	0x00200000,
	0x10040000,
	0x00200000,
	0x15000000,
	0x0F200000,
	0x15000000,
	0x0F200000,
	0x01FE0000,
	0x80000000,
	0x01800A25,
	0x00289600,
	0x007F8006,
	0x00000000,
	0x99300001,
	0x34343400,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0x00040100,
	0x00000800,
	0x00000000,
	0x00001208,
	0x00482000,
	0x01000000,
	0x00000000,
	0x00410482,
	0x0006A000,
	0x0001B400,
	0x00020000,
	0x00000400,
	0x0002A000,
	0x0001E400,
	0x5506A000,
	0x00E1D400,
	0x00000000,
	0x44B0090C,
	0x00003001,
	0x90400000,
	0x00000000,
	0x2020C243,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x00010040,
	0x00000200,
	0x00000000,
	0x00000482,
	0x00120800,
	0x00002000,
	0x80000000,
	0x00104120,
	0x00000200,
	0xAC0D5F80,
	0xFFFFFFFF,
	0x14F3690D,
	0x1A041414,
	0x00D00000,
	0x1C864000,
	0x45147A07,
	0xA228A3DA,
	0xF491451E,
	0x0358D348,
	0x821A0000,
	0x0000D000,
	0x028A0680,
	0xDA79E47A,
	0x1EA228A3,
	0xC8F49965,
	0x000344B2,
	0x00080000,
	0x00001000,
	0x00080200,
	0x00001000,
	0x000A8000,
	0x00075000,
	0x541A8000,
	0x03875001,
	0x00000000,
	0x00000020,
	0x0080C000,
	0x41000000,
	0x00003FC2,
	0x00820000,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0x00040000,
	0x00000800,
	0x00000000,
	0x00001208,
	0x00482000,
	0x01000000,
	0x00000000,
	0x00410482,
	0x0006A000,
	0x0001B400,
	0x00020000,
	0x00000400,
	0x00020080,
	0x00000400,
	0x5506A000,
	0x00E1D400,
	0x00000000,
	0x0000090C,
	0x00000010,
	0x90400000,
	0x00000000,
	0x2020C243,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x00015000,
	0x0000F200,
	0x00000000,
	0x00000482,
	0x60120800,
	0x00600289,
	0x80000000,
	0x00104120,
	0x00000200,
	0xAC0D5F80,
	0xFFFFFFFF,
	0x14F3690D,
	0x1A041414,
	0x00D00000,
	0x14864000,
	0x59647A05,
	0xC228A3DC,
	0xF491451E,
	0x0344B2C8,
	0x821A034D,
	0x0000D000,
	0x00000680,
	0xD469A47A,
	0x1E83CF23,
	0xC8F71E79,
	0x000344B2,
	0x00080000,
	0x00001000,
	0x00080000,
	0x00001000,
	0x000A8000,
	0x00075000,
	0x541A8000,
	0x03875001,
	0x00000000,
	0x00000020,
	0x0080C000,
	0x41000000,
	0x00000002,
	0x00820008,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0x00040000,
	0x00000800,
	0x00000000,
	0x00001208,
	0x00482000,
	0x01000000,
	0x00000000,
	0x00410482,
	0x0006A000,
	0x0001B400,
	0x00020000,
	0x00000400,
	0x00020080,
	0x00000400,
	0x5506A000,
	0x00E1D400,
	0x00000000,
	0x0000090C,
	0x00000010,
	0x90400000,
	0x00000000,
	0x2020C243,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x00010000,
	0x00000200,
	0x00000000,
	0x00000482,
	0x00120800,
	0x00400000,
	0x80000000,
	0x00104120,
	0x00000200,
	0xAC0D5F80,
	0xFFFFFFFF,
	0x14F1690D,
	0x1A041414,
	0x00D00000,
	0x0C864000,
	0x79E47A03,
	0x92AAA3D2,
	0xF595551E,
	0x034CF3C8,
	0x821A0000,
	0x0000D000,
	0x00000680,
	0xDA79E47A,
	0x1EA32CA3,
	0xC8F69965,
	0x000354F3,
	0x00080000,
	0x00001000,
	0x00080000,
	0x00001000,
	0x000A8000,
	0x00075000,
	0x541A8000,
	0x03875001,
	0x00000000,
	0x00000020,
	0x0080C000,
	0x41000000,
	0x00000002,
	0x00820008,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0xAA0D4000,
	0x01C3A800,
	0x00040000,
	0x00000800,
	0x00000000,
	0x00001208,
	0x00482000,
	0x01000000,
	0x00000000,
	0x00410482,
	0x0006A000,
	0x0001B400,
	0x00020000,
	0x00000400,
	0x00020000,
	0x00000400,
	0x5506A000,
	0x00E1D400,
	0x00000000,
	0x0000090C,
	0x00002000,
	0x90400000,
	0x00000000,
	0x2020C243,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x2A835000,
	0x0070EA00,
	0x00010040,
	0x00000200,
	0x00000000,
	0x00000482,
	0x00120800,
	0x00400000,
	0x80000000,
	0x00104120,
	0x00000200,
	0xAC0D5F80,
	0xFFFFFFFF,
	0x14F1690D,
	0x1A041414,
	0x00D00000,
	0x0C864000,
	0x59647A03,
	0xC3CF23DC,
	0xF711451E,
	0x0358D348,
	0x821A0000,
	0x0000D000,
	0x00000680,
	0xD459647A,
	0x1E83CF23,
	0x48F51E79,
	0x000348D3,
	0x00080000,
	0x00001000,
	0x00080000,
	0x00001000,
	0x000A8000,
	0x00075000,
	0x541A8000,
	0x03875001,
	0x00000000,
	0x00000020,
	0x0080C000,
	0x41000000,
	0x00000002,
	0x00820008,
	0x00489800,
	0x801A1A1A,
	0x00000200,
	0x80000004,
	0x00000200,
	0x80000004,
	0x00000200,
	0x00000004,
	0x00000200,
	0x00000004,
	0x00040000,
	0x10000000,
	0x00000000,
	0x00008000,
	0x00010000,
	0x40002000,
	0x00000100,
	0x40000002,
	0x00000100,
	0x00000002,
	0x00000100,
	0x40000002,
	0x00000100,
	0x00000002,
	0x00020000,
	0x00000000,
	0x00000010,
	0x00000020,
	0x00008000,
	0x20001000,
	0x00000080,
	0x20000001,
	0x00000080,
	0x20000001,
	0x00000080,
	0x20000001,
	0x00000080,
	0x00000001,
	0x00010000,
	0x04000000,
	0x00FF0000,
	0x00000000,
	0x00004000,
	0x00000800,
	0xC0000001,
	0x00141419,
	0x40000000,
	0x04000816,
	0x000D0000,
	0x00006800,
	0x00000340,
	0xD000001A,
	0x06800000,
	0x00340000,
	0x0001A000,
	0x00000D00,
	0x40000068,
	0x1A000003,
	0x00D00000,
	0x00068000,
	0x00003400,
	0x000001A0,
	0x00000401,
	0x00000008,
	0x00000401,
	0x00000008,
	0x00000401,
	0x00000008,
	0x00000401,
	0x80000008,
	0x0000007F,
	0x20000000,
	0x00000000,
	0xE0000080,
	0x0000001F,
	0x00004000,
};

#endif /* __SOCFPGA_IOCSR_CONFIG_H__ */
