# 2023-08-01 Triage Log

A very noisy week with most "regressions" simply being reflections of noise. Unfortunately the improvements were also minor and/or noise so overall the performance did not shift very much.

Triage done by **@rylev**
Revision range: [0308df2..828bdc2](https://perf.rust-lang.org/?start=0308df23e621e783e31a27ca5beaa01b9df60d4a&end=828bdc2c26f5c95773c4ecf72870919f16417b66&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 3.1%  | [3.1%, 3.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.5%, 2.5%]   | 16    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.4%, -0.4%] | 64    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-2.1%, -0.3%] | 59    |
| All ❌✅ (primary)                 | -0.8% | [-1.4%, 3.1%]  | 65    |


10 Regressions, 11 Improvements, 9 Mixed; 5 of them in rollups
107 artifact comparisons made in total

#### Regressions

match on chars instead of &strs for .split() or .strip_prefix() [#113973](https://github.com/rust-lang/rust/pull/113973) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=699f4a637ef382ea0716c72f60d0c1c4cd79df41&end=d4fe4c8b951511108d6089e771b0f6d0e1947649&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.4%] | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.2%, 1.0%] | 15    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.4%] | 1     |
- Seems like it's mostly noise and thus not worth investigating.


Fix test panics for submodule of book is not updated [#113965](https://github.com/rust-lang/rust/pull/113965) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c474aa7db03f25c5b4cdcb7bf08faac455a49086&end=d9d80e211e86b7f47b79b9c9f28b22945b7ce730&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.8%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.6%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.8%] | 4     |
- this is noise that is corrected in the next run.

Add `riscv64gc-unknown-hermit` target [#114004](https://github.com/rust-lang/rust/pull/114004) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=f475098ffdf43fbdf7765b90e60175572404e89a&end=48c0c2539542b05c35e168271e9fad72a20ac2dc&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.8% | [0.7%, 0.8%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.5% | [0.3%, 0.7%] | 10    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.8% | [0.7%, 0.8%] | 4     |
- Noise


Reimplement C-str literals [#113476](https://github.com/rust-lang/rust/pull/113476) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ff8fe76c0e36b65c038a080a8a8341024104d117&end=23405bb123681399c912552fa1c09264c0d4930d&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.7%, 0.7%] | 3     |
| Regressions ❌ <br /> (secondary)  | 0.7% | [0.5%, 1.2%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.7%, 0.7%] | 3     |
- Noise


[rustdoc] If re-export is private, get the next item until a public one is found or expose the private item directly [#113374](https://github.com/rust-lang/rust/pull/113374) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b73e9a48aeeb44fa897ab820737dfd77c5076e01&end=9339f446a5302cd5041d3f3b5e59761f36699167&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0% | [0.3%, 2.7%] | 4     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.5%] | 3     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.0% | [0.3%, 2.7%] | 4     |
- Looks like a legit regression in a very small number of crates. `render_mod_item` seems to be where more time is being spent.


Implement generic const items [#113522](https://github.com/rust-lang/rust/pull/113522) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b6dd153fbcc06b3bc936aca800af4b8376c229e4&end=04abc370b9f3855b28172b65a7f7d5a433f41412&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7% | [0.3%, 1.0%] | 17    |
| Regressions ❌ <br /> (secondary)  | 0.9% | [0.3%, 1.4%] | 9     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.7% | [0.3%, 1.0%] | 17    |
- Author is looking into the issue


fix(resolve): update the ambiguity glob binding as warning recursively [#113099](https://github.com/rust-lang/rust/pull/113099) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5ed61a4378700aeb5af88385d9ae054c8adf2322&end=2dc661037d059bff1487b76ca949ced7b3cd46c9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [1.2%, 2.6%]   | 13    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |
- Not big enough to warrant addressing.


Fix simd_bswap for i8/u8 [#114266](https://github.com/rust-lang/rust/pull/114266) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=dfc9d3fee67c1323c396b001197126dbcfa9890e&end=3be07c116128527fd9b9392f819b0dc502ff9fe5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 5.8% | [5.8%, 5.8%] | 1     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- Marginal regression - not worth investigating


Rollup of 8 pull requests [#114307](https://github.com/rust-lang/rust/pull/114307) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b3df56a65f9424a7f4af101091582f49cfc29286&end=db7ff98a72f3e742b641f9cb16d0e8c285e87e9b&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -    | -            | 0     |
| Regressions ❌ <br /> (secondary)  | 2.1% | [1.2%, 5.6%] | 5     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | -    | -            | 0     |
- Noise


Rollup of 7 pull requests [#114331](https://github.com/rust-lang/rust/pull/114331) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=828bdc2c26f5c95773c4ecf72870919f16417b66&end=4896daa3985010e7d136fe0c5bf4c4e8bfc911ae&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.4%, 0.4%] | 2     |
| Regressions ❌ <br /> (secondary)  | 0.4% | [0.3%, 0.5%] | 7     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.4%, 0.4%] | 2     |
- Too small of a regression to warrant investigation. Might just be noise.

#### Improvements

Revert "Prototype: Add unstable `-Z reference-niches` option" [#113946](https://github.com/rust-lang/rust/pull/113946) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a5e2eca40ec17f17b6641bcc7c069380ac395acf&end=a8765525fb625df692bc565f08a18362bd382c7e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.1%, -0.3%] | 13    |
| Improvements ✅ <br /> (secondary) | -1.1% | [-1.3%, -0.7%] | 4     |
| All ❌✅ (primary)                 | -0.8% | [-1.1%, -0.3%] | 13    |


Use `features()` over `features_untracked()` where possible [#113961](https://github.com/rust-lang/rust/pull/113961) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=1c44af9b791c16557b5bf606707bb76df979134a&end=cec34a43b1b14f4e39363f3b283d7ac4f593ee81&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.4%, -0.2%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -0.3% | [-0.4%, -0.2%] | 2     |


Migrate GUI colors test to original CSS color format [#113976](https://github.com/rust-lang/rust/pull/113976) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9d80e211e86b7f47b79b9c9f28b22945b7ce730&end=8771282d4e7a5c4569e49d1f878fb3ba90a974d0&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.6%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.3%] | 6     |
| All ❌✅ (primary)                 | -0.7% | [-0.7%, -0.6%] | 4     |


lint/ctypes: only try normalize [#113921](https://github.com/rust-lang/rust/pull/113921) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fc8a3e357a0a5e317132e5ff8858ec70970fb07a&end=fd56162af035fbbbd08e87826ed14e9539aedcb6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.5%  | [1.5%, 1.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-0.8%, -0.7%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.8%, -0.3%] | 10    |
| All ❌✅ (primary)                 | -0.8% | [-0.8%, -0.7%] | 4     |


Replace in-tree `rustc_apfloat` with the new version of the crate [#113843](https://github.com/rust-lang/rust/pull/113843) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fb7e6d078d83d2d06b0c1fd27c97767545f105d7&end=0d95f9132909ae7c5f2456748d0ffd1c3ba4a8e8&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.3%] | 6     |
| Improvements ✅ <br /> (secondary) | -1.2% | [-1.2%, -1.1%] | 4     |
| All ❌✅ (primary)                 | -0.4% | [-0.5%, -0.3%] | 6     |


Rollup of 7 pull requests [#114116](https://github.com/rust-lang/rust/pull/114116) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d150dbb067e66f351a0b33a54e7d4b464ef51e47&end=3e11b223d7ad9836babf2d531b0ca6d13ff3f065&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.0%  | [2.0%, 2.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.5%, -0.2%] | 28    |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 10    |
| All ❌✅ (primary)                 | -0.3% | [-0.5%, -0.2%] | 28    |


Remove `constness` from `ParamEnv` [#114134](https://github.com/rust-lang/rust/pull/114134) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=37343f4a4d4ed7ad0891cb79e8eb25acf43fb821&end=aafd75a9c510b0e91746b891eb4ebade43899af5&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.6%, -0.3%] | 23    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.7%, -0.3%] | 16    |
| All ❌✅ (primary)                 | -0.4% | [-0.6%, -0.3%] | 23    |


Optimize `TokenKind::clone`. [#114119](https://github.com/rust-lang/rust/pull/114119) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e4c98caffe505630f8531fbb73949b40db918a48&end=b95fd857fe464e7dcb87b159e1f96c30709c236e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-1.5%, -0.5%] | 10    |
| Improvements ✅ <br /> (secondary) | -0.7% | [-1.0%, -0.3%] | 7     |
| All ❌✅ (primary)                 | -1.0% | [-1.5%, -0.5%] | 10    |


Rollup of 4 pull requests [#114272](https://github.com/rust-lang/rust/pull/114272) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d9feb02e8d6ed0e2fe2620669841f6aff105a0e5&end=dfc9d3fee67c1323c396b001197126dbcfa9890e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.7% | [-5.7%, -5.7%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Only golden arches [#114225](https://github.com/rust-lang/rust/pull/114225) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3be07c116128527fd9b9392f819b0dc502ff9fe5&end=03b8b50fcb0c95e1f5ce303572ed4516a59a9b15&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -5.4% | [-5.4%, -5.4%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |


Change default panic handler message format. [#112849](https://github.com/rust-lang/rust/pull/112849) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=c435af0d5c47a333c7cb7f359f3586d5c9dab3ab&end=828bdc2c26f5c95773c4ecf72870919f16417b66&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 2     |


Remove `constness` from `TraitPredicate` [#114202](https://github.com/rust-lang/rust/pull/114202) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7637653b9fdd2b2f2dc3b378891eb5cf6aea9f5d&end=20747af8940cf683970e76ec9a433305940c05f3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.9%, -0.4%] | 16    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-1.2%, -0.3%] | 13    |
| All ❌✅ (primary)                 | -0.7% | [-0.9%, -0.4%] | 16    |


#### Mixed

Add #[inline] to core debug assertion helpers [#113687](https://github.com/rust-lang/rust/pull/113687) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=fd56162af035fbbbd08e87826ed14e9539aedcb6&end=31395ec38250b60b380fd3c27e94756aba3557de&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.7%  | [0.6%, 0.7%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 0.6%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.1%  | [-0.3%, 0.7%]  | 5     |
- The small number of icount regressions are inconsequential. The large number of binary size reductions are very nice.

delete [allow(unused_unsafe)] from issue #74838 [#111362](https://github.com/rust-lang/rust/pull/111362) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=31395ec38250b60b380fd3c27e94756aba3557de&end=1821920cc8e7dc44b0035da890170bf3eadc2ae9&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.6%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.5%, -0.3%] | 5     |
| All ❌✅ (primary)                 | -0.5% | [-0.7%, 0.4%]  | 5     |
- One tiny regression; this is fine.


interpret: Unify projections for MPlaceTy, PlaceTy, OpTy [#114011](https://github.com/rust-lang/rust/pull/114011) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=23405bb123681399c912552fa1c09264c0d4930d&end=4fc6b33474680ba57e10d56371c2c3df91788e26&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.8%  | [2.4%, 3.2%]   | 6     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.8%, -0.7%] | 3     |
| Improvements ✅ <br /> (secondary) | -1.0% | [-1.5%, -0.5%] | 10    |
| All ❌✅ (primary)                 | -0.7% | [-0.8%, -0.7%] | 3     |
- the regressions that are least likely to be noise are in CTE stress tests. Given the stress nature of the test, the smallish regressions probably aren't worth investigating. Asked author if this is something worth looking into.


Don't treat negative trait predicates as always knowable [#114080](https://github.com/rust-lang/rust/pull/114080) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=3e11b223d7ad9836babf2d531b0ca6d13ff3f065&end=2efa46dc159b2b4717eff487e2b653c263476aa9&stat=instructions:u)

| (instructions:u)                   | mean   | range           | count |
|:----------------------------------:|:------:|:---------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%   | [0.2%, 0.2%]    | 1     |
| Regressions ❌ <br /> (secondary)  | 0.3%   | [0.3%, 0.4%]    | 3     |
| Improvements ✅ <br /> (primary)   | -0.8%  | [-0.8%, -0.8%]  | 1     |
| Improvements ✅ <br /> (secondary) | -29.9% | [-57.8%, -1.9%] | 2     |
| All ❌✅ (primary)                 | -0.3%  | [-0.8%, 0.2%]   | 2     |
- A small mixture of tiny wins and losses, nothing to worry about.


Implement diagnostic translation for rustc-errors [#113281](https://github.com/rust-lang/rust/pull/113281) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=2efa46dc159b2b4717eff487e2b653c263476aa9&end=f239bb6bea94d16d902c36d72b5cabdddefb3cab&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 69.5% | [2.1%, 136.8%] | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.3%] | 2     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.5%, -0.3%] | 3     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.3%] | 2     |
- The huge unused-warnings check incr-unchanged regression here was just a blip and immediately disappeared in #114080.


Build the first LLVM without LTO in try builds [#113779](https://github.com/rust-lang/rust/pull/113779) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0eb5efc7ae7479367c3d4567465cb042df176e71&end=0be11523110a8354120068cd5c69434fdec2dc87&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.6%, 0.6%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-0.6%, -0.6%] | 3     |
| Improvements ✅ <br /> (secondary) | -0.5% | [-0.6%, -0.5%] | 5     |
| All ❌✅ (primary)                 | -0.6% | [-0.6%, -0.6%] | 3     |
- Noise


Rollup of 6 pull requests [#114264](https://github.com/rust-lang/rust/pull/114264) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a8be6e070f02fca6e5ab851e10e29d45c3a0217c&end=a17c7968b727d8413801961fc4e89869b6ab00d3&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [1.0%, 1.0%]   | 2     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.3%] | 3     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.2% | [-0.5%, 0.4%]  | 4     |
- Changes are a wash so not worth investigating.


Print omitted frames count for short backtrace mode [#112843](https://github.com/rust-lang/rust/pull/112843) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a17c7968b727d8413801961fc4e89869b6ab00d3&end=d4145eeef476abee0faebf6649dc02c6a6440e1e&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 6.1%  | [6.1%, 6.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.4%, -0.4%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.4% | [-0.4%, -0.4%] | 1     |
- Seems like the start of noise


Only consider places with the same local in each_borrow_involving_path. [#111753](https://github.com/rust-lang/rust/pull/111753) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b484c87811da40b919f2918ac77bb426d905d9e5&end=866710c552e5a9b9ce6d0f8143ebe8d69f7dd451&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.6%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.7%, 5.9%]   | 5     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-0.5%, -0.4%] | 2     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.5%, 0.6%]  | 8     |
- Potentially being reverted in https://github.com/rust-lang/rust/pull/114337
