/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <string.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"
#include "file/file-open.h"
#include "file/file-save.h"
#include "file/file-utils.h"
#include "plug-in/gimppluginmanager-file.h"

#include "gimppdb.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static GimpValueArray *
file_load_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  GimpValueArray      *new_args;
  GimpValueArray      *return_vals;
  GimpPlugInProcedure *file_proc;
  GimpProcedure       *proc;
  GFile               *file;
  gint                 i;

  file = g_value_get_object (gimp_value_array_index (args, 1));

  if (! file)
    return gimp_procedure_get_return_values (procedure, FALSE,
                                             error ? *error : NULL);

  file_proc = gimp_plug_in_manager_file_procedure_find (gimp->plug_in_manager,
                                                        GIMP_FILE_PROCEDURE_GROUP_OPEN,
                                                        file, error);

  if (! file_proc)
    return gimp_procedure_get_return_values (procedure, FALSE,
                                             error ? *error : NULL);

  proc = GIMP_PROCEDURE (file_proc);

  new_args = gimp_procedure_get_arguments (proc);

  g_value_transform (gimp_value_array_index (args, 0),
                     gimp_value_array_index (new_args, 0));
  g_value_transform (gimp_value_array_index (args, 1),
                     gimp_value_array_index (new_args, 1));

  for (i = 2; i < proc->num_args; i++)
    if (G_IS_PARAM_SPEC_STRING (proc->args[i]))
      g_value_set_static_string (gimp_value_array_index (new_args, i), "");

  return_vals =
    gimp_pdb_execute_procedure_by_name_args (gimp->pdb,
                                             context, progress, error,
                                             gimp_object_get_name (proc),
                                             new_args);

  gimp_value_array_unref (new_args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) ==
      GIMP_PDB_SUCCESS)
    {
      if (gimp_value_array_length (return_vals) > 1 &&
          GIMP_VALUE_HOLDS_IMAGE (gimp_value_array_index (return_vals, 1)))
        {
          GimpImage *image =
            g_value_get_object (gimp_value_array_index (return_vals, 1));
          gimp_image_set_load_proc (image, file_proc);
        }
    }

  return return_vals;
}

static GimpValueArray *
file_load_layer_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint run_mode;
  GimpImage *image;
  GFile *file;
  GimpLayer *layer = NULL;

  run_mode = g_value_get_enum (gimp_value_array_index (args, 0));
  image = g_value_get_object (gimp_value_array_index (args, 1));
  file = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      GList             *layers;
      GimpPDBStatusType  status;

      layers = file_open_layers (gimp, context, progress,
                                 image, FALSE, FALSE,
                                 file, run_mode, NULL, &status, error);

      if (layers)
        {
          layer = layers->data;
          g_list_free (layers);
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), layer);

  return return_vals;
}

static GimpValueArray *
file_load_layers_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  gint run_mode;
  GimpImage *image;
  GFile *file;
  GimpLayer **layers = NULL;

  run_mode = g_value_get_enum (gimp_value_array_index (args, 0));
  image = g_value_get_object (gimp_value_array_index (args, 1));
  file = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      GList             *layer_list;
      GimpPDBStatusType  status;

      layer_list = file_open_layers (gimp, context, progress,
                                     image, FALSE, FALSE,
                                     file, run_mode, NULL, &status, error);

      if (layer_list)
        {
          GList *list;
          gsize  num_layers;
          gint   i;

          num_layers = g_list_length (layer_list);

          layers = g_new0 (GimpLayer *, num_layers + 1);

          for (i = 0, list = layer_list;
               i < num_layers;
               i++, list = g_list_next (list))
            {
              layers[i] = list->data;
            }

          g_list_free (layer_list);
        }
      else
        {
          success = FALSE;
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_boxed (gimp_value_array_index (return_vals, 1), layers);

  return return_vals;
}

static GimpValueArray *
file_save_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  GimpValueArray      *new_args;
  GimpValueArray      *return_vals;
  GimpPlugInProcedure *file_proc;
  GFile               *file;
  GimpProcedure       *proc;
  gint                 custom_args_start = 3;
  gint                 i;

  file = g_value_get_object (gimp_value_array_index (args, 2));

  file_proc = gimp_plug_in_manager_file_procedure_find (gimp->plug_in_manager,
                                                        GIMP_FILE_PROCEDURE_GROUP_SAVE,
                                                        file, NULL);

  if (! file_proc)
    file_proc = gimp_plug_in_manager_file_procedure_find (gimp->plug_in_manager,
                                                          GIMP_FILE_PROCEDURE_GROUP_EXPORT,
                                                          file, error);

  if (! file_proc)
    return gimp_procedure_get_return_values (procedure, FALSE,
                                             error ? *error : NULL);

  proc = GIMP_PROCEDURE (file_proc);

  new_args = gimp_procedure_get_arguments (proc);

  g_value_transform (gimp_value_array_index (args, 0),
                     gimp_value_array_index (new_args, 0));
  g_value_transform (gimp_value_array_index (args, 1),
                     gimp_value_array_index (new_args, 1));
  g_value_transform (gimp_value_array_index (args, 2),
                     gimp_value_array_index (new_args, 2));
  if (proc->num_args > 3)
    {
      custom_args_start++;
      g_value_transform (gimp_value_array_index (args, 3),
                         gimp_value_array_index (new_args, 3));
    }

  for (i = custom_args_start; i < proc->num_args; i++)
    if (GIMP_IS_PARAM_SPEC_CHOICE (proc->args[i]))
      {
        GParamSpecString *string_spec = G_PARAM_SPEC_STRING (proc->args[i]);

        g_value_set_static_string (gimp_value_array_index (new_args, i),
                                   string_spec->default_value);
      }
    else if (G_IS_PARAM_SPEC_STRING (proc->args[i]))
      {
        g_value_set_static_string (gimp_value_array_index (new_args, i), "");
      }

  return_vals =
    gimp_pdb_execute_procedure_by_name_args (gimp->pdb,
                                             context, progress, error,
                                             gimp_object_get_name (proc),
                                             new_args);

  if (g_value_get_enum (gimp_value_array_index (return_vals, 0)) ==
      GIMP_PDB_SUCCESS)
    {
      GimpImage *image =
        g_value_get_object (gimp_value_array_index (new_args, 1));

      if (! strcmp (gimp_object_get_name (proc), "gimp-xcf-save"))
        {
          gimp_image_set_file (image, file);

          gimp_image_set_imported_file (image, NULL);
          gimp_image_clean_all (image);
        }
      else
        {
          gimp_image_set_exported_file (image, file);
          gimp_image_set_export_proc (image, file_proc);

          gimp_image_set_imported_file (image, NULL);
          gimp_image_export_clean_all (image);
        }
    }
  gimp_value_array_unref (new_args);

  return return_vals;
}

static GimpValueArray *
file_load_thumbnail_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GFile *file;
  gint width = 0;
  gint height = 0;
  GBytes *thumb_data = NULL;

  file = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      GdkPixbuf *pixbuf = file_utils_load_thumbnail (file);

      if (pixbuf)
        {
          width            = gdk_pixbuf_get_width (pixbuf);
          height           = gdk_pixbuf_get_height (pixbuf);
          thumb_data       = g_bytes_new (gdk_pixbuf_get_pixels (pixbuf),
                                          3 * width * height);

          g_object_unref (pixbuf);
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_int (gimp_value_array_index (return_vals, 1), width);
      g_value_set_int (gimp_value_array_index (return_vals, 2), height);
      g_value_take_boxed (gimp_value_array_index (return_vals, 3), thumb_data);
    }

  return return_vals;
}

static GimpValueArray *
file_create_thumbnail_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpImage *image;
  GFile *file;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  file = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      success = file_utils_save_thumbnail (image, file);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_file_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-file-load
   */
  procedure = gimp_procedure_new (file_load_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load");
  gimp_procedure_set_static_help (procedure,
                                  "Loads an image file by invoking the right load handler.",
                                  "This procedure invokes the correct file load handler using magic if possible, and falling back on the file's extension and/or prefix if not.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Josh MacDonald",
                                         "Josh MacDonald",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("run-mode",
                                                     "run mode",
                                                     "The run mode",
                                                     GIMP_TYPE_RUN_MODE,
                                                     GIMP_RUN_INTERACTIVE,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[0]),
                                      GIMP_RUN_WITH_LAST_VALS);
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file to load",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_image ("image",
                                                          "image",
                                                          "The output image",
                                                          FALSE,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-load-layer
   */
  procedure = gimp_procedure_new (file_load_layer_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load-layer");
  gimp_procedure_set_static_help (procedure,
                                  "Loads an image file as a layer for an existing image.",
                                  "This procedure behaves like the file-load procedure but opens the specified image as a layer for an existing image. The returned layer needs to be added to the existing image with 'gimp-image-insert-layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2005");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("run-mode",
                                                     "run mode",
                                                     "The run mode",
                                                     GIMP_TYPE_RUN_MODE,
                                                     GIMP_RUN_INTERACTIVE,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[0]),
                                      GIMP_RUN_WITH_LAST_VALS);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "Destination image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file to load",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer ("layer",
                                                          "layer",
                                                          "The layer created when loading the image file",
                                                          FALSE,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-load-layers
   */
  procedure = gimp_procedure_new (file_load_layers_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load-layers");
  gimp_procedure_set_static_help (procedure,
                                  "Loads an image file as layers for an existing image.",
                                  "This procedure behaves like the file-load procedure but opens the specified image as layers for an existing image. The returned layers needs to be added to the existing image with 'gimp-image-insert-layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Michael Natterer <mitch@gimp.org>",
                                         "Michael Natterer",
                                         "2006");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_enum ("run-mode",
                                                     "run mode",
                                                     "The run mode",
                                                     GIMP_TYPE_RUN_MODE,
                                                     GIMP_RUN_INTERACTIVE,
                                                     GIMP_PARAM_READWRITE));
  gimp_param_spec_enum_exclude_value (GIMP_PARAM_SPEC_ENUM (procedure->args[0]),
                                      GIMP_RUN_WITH_LAST_VALS);
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "Destination image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file to load",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_core_object_array ("layers",
                                                                      "layers",
                                                                      "The list of loaded layers",
                                                                      GIMP_TYPE_LAYER,
                                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-save
   */
  procedure = gimp_procedure_new (file_save_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-save");
  gimp_procedure_set_static_help (procedure,
                                  "Saves to XCF or export @image to any supported format by extension.",
                                  "This procedure invokes the correct file save/export handler according to @file's extension and/or prefix.\n"
                                  "\n"
                                  "The @options argument is currently unused and should be set to %NULL right now.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Josh MacDonald",
                                         "Josh MacDonald",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("run-mode",
                                                  "run mode",
                                                  "The run mode",
                                                  GIMP_TYPE_RUN_MODE,
                                                  GIMP_RUN_INTERACTIVE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "Input image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file to save or export the image in",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_export_options ("options",
                                                               "options",
                                                               "Export option settings",
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-load-thumbnail
   */
  procedure = gimp_procedure_new (file_load_thumbnail_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-load-thumbnail");
  gimp_procedure_set_static_help (procedure,
                                  "Loads the thumbnail for a file.",
                                  "This procedure tries to load a thumbnail that belongs to the given file. The returned data is an array of colordepth 3 (RGB), regardless of the image type. Width and height of the thumbnail are also returned. Don't use this function if you need a thumbnail of an already opened image, use 'gimp-image-thumbnail' instead.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Adam D. Moss, Sven Neumann",
                                         "Adam D. Moss, Sven Neumann",
                                         "1999-2003");
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file that owns the thumbnail to load",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("width",
                                                     "width",
                                                     "The width of the thumbnail",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_int ("height",
                                                     "height",
                                                     "The height of the thumbnail",
                                                     G_MININT32, G_MAXINT32, 0,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boxed ("thumb-data",
                                                       "thumb data",
                                                       "The thumbnail data",
                                                       G_TYPE_BYTES,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-file-create-thumbnail
   */
  procedure = gimp_procedure_new (file_create_thumbnail_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-file-create-thumbnail");
  gimp_procedure_set_static_help (procedure,
                                  "Creates a thumbnail of @image for the given @file",
                                  "This procedure creates a thumbnail for the given @file and stores it according to relevant standards.\n"
                                  "In particular, it will follow the [Free Desktop Thumbnail Managing Standard](https://specifications.freedesktop.org/thumbnail-spec/latest/thumbsave.html) when relevant.\n"
                                  "\n"
                                  "The thumbnail is stored so that it belongs to the given @file. This means you have to save @image under this name first. As a fallback, the call will work if @image was exported or imported as @file. In any other case, this procedure will fail.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Josh MacDonald",
                                         "Josh MacDonald",
                                         "1997");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_object ("file",
                                                    "file",
                                                    "The file the thumbnail belongs to",
                                                    G_TYPE_FILE,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
