/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.settings;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramFileEditor;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.util.DiagramUpdateService;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.uml.settings.DiagramSettingsForm;
import com.intellij.uml.utils.DiagramBundle;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class UmlConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private DiagramSettingsForm mySettings;

    @Nls
    public String getDisplayName() {
        return DiagramBundle.message("configurable.UmlConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.ide.settings.uml";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            UmlConfigurable.$$$reportNull$$$0(0);
        }
        return string;
    }

    public JComponent createComponent() {
        if (this.mySettings == null) {
            this.mySettings = new DiagramSettingsForm(DiagramConfiguration.getInstance());
        }
        return this.mySettings.getJComponent();
    }

    public boolean isModified() {
        return this.mySettings.changed();
    }

    public void apply() {
        this.mySettings.apply();
        GraphAnimationService.getInstance().setAnimationEnabledGlobally(DiagramConfiguration.getInstance().isAnimationsEnabled());
        GraphAnimationService.getInstance().setLayoutAnimationDuration(DiagramConfiguration.getInstance().getLayoutAnimationDurationMillis());
        FileEditorManager manager = FileEditorManager.getInstance((Project)ProjectUtil.guessCurrentProject((JComponent)this.mySettings.getJComponent()));
        if (manager == null) {
            return;
        }
        for (FileEditor editor : manager.getAllEditors()) {
            if (!(editor instanceof DiagramFileEditor)) continue;
            DiagramFileEditor diagramFileEditor = (DiagramFileEditor)editor;
            DiagramBuilder builder = diagramFileEditor.getModelBuilder();
            DiagramUpdateService.getInstance().requestDataModelRefreshPreservingLayout(builder).runAsync();
        }
    }

    public void reset() {
        this.mySettings.reset();
    }

    public void disposeUIResources() {
        this.mySettings = null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uml/settings/UmlConfigurable", "getId"));
    }
}

