/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;
import org.jetbrains.kotlinx.dataframe.impl.api.UpdateKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a9\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0016\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0004\"\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006\u001a&\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u00012\b\b\u0002\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"append", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "T", "values", "", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;[Ljava/lang/Object;)Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "appendNulls", "numberOfRows", "", "core"})
@SourceDebugExtension(value={"SMAP\nappend.kt\nKotlin\n*S Kotlin\n*F\n+ 1 append.kt\norg/jetbrains/kotlinx/dataframe/api/AppendKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1#2:32\n1559#3:33\n1590#3,3:34\n1549#3:37\n1620#3,3:38\n1593#3:41\n1549#3:42\n1620#3,3:43\n*S KotlinDebug\n*F\n+ 1 append.kt\norg/jetbrains/kotlinx/dataframe/api/AppendKt\n*L\n15#1:33\n15#1:34,3\n16#1:37\n16#1:38,3\n15#1:41\n25#1:42\n25#1:43,3\n*E\n"})
public final class AppendKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> append(@NotNull DataFrame<? extends T> $this$append, Object ... values2) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$append, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int ncol = DataFrameKt.getNcol((ColumnsContainer)$this$append);
        if (!(values2.length % ncol == 0)) {
            boolean $i$a$-check-AppendKt$append$22 = false;
            String $i$a$-check-AppendKt$append$22 = "Invalid number of arguments. Multiple of " + ncol + " is expected, but actual was: " + values2.length;
            throw new IllegalStateException($i$a$-check-AppendKt$append$22.toString());
        }
        int newRows = values2.length / ncol;
        Iterable $this$mapIndexed$iv = $this$append.columns();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void col2;
            void $this$mapTo$iv$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)newRows);
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                void colIndex;
                int item$iv$iv2;
                int n3 = item$iv$iv2 = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(values2[colIndex + it * ncol]);
            }
            List newValues = (List)destination$iv$iv2;
            collection.add(UpdateKt.updateWith(col2, CollectionsKt.plus(BaseColumnKt.getValues((BaseColumn)col2), (Iterable)newValues)));
        }
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> appendNulls(@NotNull DataFrame<? extends T> $this$appendNulls, int numberOfRows) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$appendNulls, (String)"<this>");
        if (!(numberOfRows >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (numberOfRows == 0) {
            return $this$appendNulls;
        }
        if (DataFrameKt.getNcol((ColumnsContainer)$this$appendNulls) == 0) {
            return CastKt.cast(DataFrame.Companion.empty(DataFrameKt.getNrow($this$appendNulls) + numberOfRows));
        }
        Iterable $this$map$iv = $this$appendNulls.columns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void col2;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(UpdateKt.updateWith(col2, CollectionsKt.plus(BaseColumnKt.getValues((BaseColumn)col2), (Object[])new Object[numberOfRows])));
        }
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv));
    }

    public static /* synthetic */ DataFrame appendNulls$default(DataFrame dataFrame, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return AppendKt.appendNulls(dataFrame, n);
    }
}

