/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.ColumnsContainer;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.api.DataFrameGetKt;
import org.jetbrains.kotlinx.dataframe.api.IndicesKt;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.api.TypeConversionsKt;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumn;
import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnReference;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.columns.FrameColumn;
import org.jetbrains.kotlinx.dataframe.columns.SingleColumn;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001d\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0086\u0002\u001a!\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\u000e\u0010\u0003\u001a\n\u0012\u0002\b\u00030\u0005j\u0002`\u0006H\u0086\u0002\u001a\u001a\u0010\u0007\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u001a\"\u0010\u0007\u001a\u00020\u0001\"\u0004\b\u0000\u0010\b*\u0006\u0012\u0002\b\u00030\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\b0\u0005\u001a&\u0010\t\u001a\n\u0012\u0002\b\u00030\nj\u0002`\u000b\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a&\u0010\t\u001a\n\u0012\u0002\b\u00030\nj\u0002`\u000b\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001ar\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u00022N\u0010\u0011\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00160\u0012j\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\b`\u0017\u00a2\u0006\u0002\b\u0018\u001a&\u0010\t\u001a\n\u0012\u0002\b\u00030\nj\u0002`\u000b\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010\u0019\u001a\u00020\u001a\u001a0\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u001b0\n\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H\f0\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u0005\u001a6\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001c\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u001d0\u0005\u001a6\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001e\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\u001b*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001b0\u001f0\u0005\u001a\"\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010\r\u001a\u00020\u000e\u001a\"\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a&\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u001a~\u0010 \u001a\b\u0012\u0004\u0012\u0002H\b0\u001e\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u00022Z\u0010\u0003\u001aV\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u001f0\u00160\u0012j\u0014\u0012\u0004\u0012\u0002H\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u001f`\u0017\u00a2\u0006\u0002\b\u0018\u001a\"\u0010 \u001a\u0006\u0012\u0002\b\u00030\u001e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010!\u001a\u00020\u001a\u001a6\u0010 \u001a\b\u0012\u0004\u0012\u0002H\b0\u001e\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0012\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u001f0\u0005\u001a$\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u001a(\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u001a&\u0010#\u001a\u00020\u000e\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d2\u000e\u0010$\u001a\n\u0012\u0002\b\u00030\nj\u0002`\u000b\u001al\u0010%\u001a\u00020\u001a\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u001d2N\u0010\u0011\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00160\u0012j\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\b`\u0017\u00a2\u0006\u0002\b\u0018\u001ar\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001a0'\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u001d2N\u0010\u0011\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0(0\u0012j\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\b`)\u00a2\u0006\u0002\b\u0018\u001ar\u0010*\u001a\b\u0012\u0004\u0012\u0002H\b0+\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u001d2N\u0010\u0011\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\u00160\u0012j\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\b`\u0017\u00a2\u0006\u0002\b\u0018\u001a=\u0010,\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u00030\nj\u0002`\u000b0'\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d2\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100.\"\u00020\u0010\u00a2\u0006\u0002\u0010/\u001ax\u0010,\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\n0'\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u001d2N\u0010\u0011\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0(0\u0012j\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\b`)\u00a2\u0006\u0002\b\u0018\u001ax\u00100\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0+0'\"\u0004\b\u0000\u0010\f\"\u0004\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\f0\u001d2N\u0010\u0011\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u0013\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\f0\u0013\u00a2\u0006\f\b\u0014\u0012\b\b\u000f\u0012\u0004\b\b(\u0015\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0(0\u0012j\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\b`)\u00a2\u0006\u0002\b\u0018\u001a\"\u00101\u001a\u0006\u0012\u0002\b\u00030\u001c\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u00102\u001a\u00020\u0010\u001a\"\u00101\u001a\u0006\u0012\u0002\b\u00030\u001c\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u00022\u0006\u0010!\u001a\u00020\u001a\u001a&\u00103\u001a\n\u0012\u0004\u0012\u0002H\f\u0018\u00010\u001f\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d2\u0006\u0010\r\u001a\u00020\u000e\u001a*\u00104\u001a\b\u0012\u0004\u0012\u0002H\f0\u001d\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000e06\u001a$\u00104\u001a\b\u0012\u0004\u0012\u0002H\f0\u001d\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d2\u0006\u00107\u001a\u000208\u001a\"\u00109\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001f06\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d\u001a\"\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\f0\u001f06\"\u0004\b\u0000\u0010\f*\b\u0012\u0004\u0012\u0002H\f0\u001d\u00a8\u0006;"}, d2={"contains", "", "Lorg/jetbrains/kotlinx/dataframe/ColumnsContainer;", "column", "Lkotlin/reflect/KProperty;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnReference;", "Lorg/jetbrains/kotlinx/dataframe/AnyColumnReference;", "containsColumn", "C", "getColumn", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "Lorg/jetbrains/kotlinx/dataframe/AnyCol;", "T", "index", "", "name", "", "selector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lkotlin/ParameterName;", "it", "Lorg/jetbrains/kotlinx/dataframe/columns/SingleColumn;", "Lorg/jetbrains/kotlinx/dataframe/ColumnSelector;", "Lkotlin/ExtensionFunctionType;", "path", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "R", "Lorg/jetbrains/kotlinx/dataframe/columns/FrameColumn;", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnGroup;", "Lorg/jetbrains/kotlinx/dataframe/DataRow;", "getColumnGroup", "columnPath", "getColumnGroupOrNull", "getColumnIndex", "col", "getColumnPath", "getColumnPaths", "", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "getColumnWithPath", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "getColumns", "columns", "", "(Lorg/jetbrains/kotlinx/dataframe/DataFrame;[Ljava/lang/String;)Ljava/util/List;", "getColumnsWithPaths", "getFrameColumn", "columnName", "getOrNull", "getRows", "indices", "", "range", "Lkotlin/ranges/IntRange;", "rows", "rowsReversed", "core"})
@SourceDebugExtension(value={"SMAP\nDataFrameGet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataFrameGet.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameGetKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1549#2:154\n1620#2,3:155\n1549#2:158\n1620#2,3:159\n*S KotlinDebug\n*F\n+ 1 DataFrameGet.kt\norg/jetbrains/kotlinx/dataframe/api/DataFrameGetKt\n*L\n45#1:154\n45#1:155,3\n48#1:158\n48#1:159,3\n*E\n"})
public final class DataFrameGetKt {
    @NotNull
    public static final <T, C> List<ColumnWithPath<C>> getColumnsWithPaths(@NotNull DataFrame<? extends T> $this$getColumnsWithPaths, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnsWithPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return UtilsKt.getColumnsWithPaths($this$getColumnsWithPaths, UnresolvedColumnsPolicy.Fail, selector);
    }

    @NotNull
    public static final <T, C> ColumnPath getColumnPath(@NotNull DataFrame<? extends T> $this$getColumnPath, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnPath, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return (ColumnPath)CollectionsKt.single(DataFrameGetKt.getColumnPaths($this$getColumnPath, selector));
    }

    @NotNull
    public static final <T, C> List<ColumnPath> getColumnPaths(@NotNull DataFrame<? extends T> $this$getColumnPaths, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return UtilsKt.getColumnPaths($this$getColumnPaths, UnresolvedColumnsPolicy.Fail, selector);
    }

    @NotNull
    public static final <T, C> ColumnWithPath<C> getColumnWithPath(@NotNull DataFrame<? extends T> $this$getColumnWithPath, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnWithPath, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return (ColumnWithPath)CollectionsKt.single(DataFrameGetKt.getColumnsWithPaths($this$getColumnWithPath, selector));
    }

    @NotNull
    public static final <T, C> List<DataColumn<C>> getColumns(@NotNull DataFrame<? extends T> $this$getColumns, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumns, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return $this$getColumns.get(selector);
    }

    @NotNull
    public static final <T> List<DataColumn<?>> getColumns(@NotNull DataFrame<? extends T> $this$getColumns, String ... columns2) {
        Intrinsics.checkNotNullParameter($this$getColumns, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)columns2, (String)"columns");
        return DataFrameGetKt.getColumns($this$getColumns, (Function2)new Function2<ColumnsSelectionDsl<? extends T>, ColumnsSelectionDsl<? extends T>, ColumnsResolver<? extends Object>>(columns2){
            final /* synthetic */ String[] $columns;
            {
                this.$columns = $columns;
                super(2);
            }

            @NotNull
            public final ColumnsResolver<Object> invoke(@NotNull ColumnsSelectionDsl<? extends T> $this$getColumns, @NotNull ColumnsSelectionDsl<? extends T> it) {
                Intrinsics.checkNotNullParameter($this$getColumns, (String)"$this$getColumns");
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return ConstructorsKt.toColumnSetString(this.$columns);
            }
        });
    }

    public static final <T> int getColumnIndex(@NotNull DataFrame<? extends T> $this$getColumnIndex, @NotNull DataColumn<?> col2) {
        Intrinsics.checkNotNullParameter($this$getColumnIndex, (String)"<this>");
        Intrinsics.checkNotNullParameter(col2, (String)"col");
        return $this$getColumnIndex.getColumnIndex(col2.name());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> getRows(@NotNull DataFrame<? extends T> $this$getRows, @NotNull IntRange range) {
        DataFrame<T> dataFrame;
        Intrinsics.checkNotNullParameter($this$getRows, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)range, (Object)IndicesKt.indices($this$getRows))) {
            dataFrame = $this$getRows;
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getRows.columns();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void col2;
                DataColumn dataColumn = (DataColumn)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(col2.get(range));
            }
            dataFrame = CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv));
        }
        return dataFrame;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<T> getRows(@NotNull DataFrame<? extends T> $this$getRows, @NotNull Iterable<Integer> indices) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getRows, (String)"<this>");
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        Iterable $this$map$iv = $this$getRows.columns();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void col2;
            DataColumn dataColumn = (DataColumn)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(col2.get(indices));
        }
        return CastKt.cast(ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv));
    }

    @Nullable
    public static final <T> DataRow<T> getOrNull(@NotNull DataFrame<? extends T> $this$getOrNull, int index) {
        Intrinsics.checkNotNullParameter($this$getOrNull, (String)"<this>");
        return index < 0 || index >= DataFrameKt.getNrow($this$getOrNull) ? null : $this$getOrNull.get(index);
    }

    @NotNull
    public static final <T> FrameColumn<?> getFrameColumn(@NotNull ColumnsContainer<? extends T> $this$getFrameColumn, @NotNull ColumnPath columnPath) {
        Intrinsics.checkNotNullParameter($this$getFrameColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)columnPath, (String)"columnPath");
        return org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.asAnyFrameColumn($this$getFrameColumn.get(columnPath));
    }

    @NotNull
    public static final <T> FrameColumn<?> getFrameColumn(@NotNull ColumnsContainer<? extends T> $this$getFrameColumn, @NotNull String columnName) {
        Intrinsics.checkNotNullParameter($this$getFrameColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        return org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.asAnyFrameColumn($this$getFrameColumn.get(columnName));
    }

    @NotNull
    public static final <T> ColumnGroup<?> getColumnGroup(@NotNull ColumnsContainer<? extends T> $this$getColumnGroup, @NotNull ColumnPath columnPath) {
        Intrinsics.checkNotNullParameter($this$getColumnGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)columnPath, (String)"columnPath");
        return TypeConversionsKt.asColumnGroupUntyped($this$getColumnGroup.get(columnPath));
    }

    @NotNull
    public static final <T> DataColumn<?> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DataColumn<?> dataColumn = $this$getColumn.getColumnOrNull(name);
        if (dataColumn == null) {
            throw new IllegalArgumentException("Column not found: '" + name + '\'');
        }
        return dataColumn;
    }

    @NotNull
    public static final <T, R> FrameColumn<R> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, @NotNull ColumnReference<? extends DataFrame<? extends R>> column2) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        DataColumn<DataFrame<R>> dataColumn = $this$getColumn.getColumnOrNull(column2);
        if (dataColumn == null || (dataColumn = TypeConversionsKt.asFrameColumn(dataColumn)) == null) {
            throw new IllegalArgumentException("FrameColumn not found: '" + column2 + '\'');
        }
        return dataColumn;
    }

    @NotNull
    public static final <T, R> ColumnGroup<R> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, @NotNull ColumnReference<? extends DataRow<? extends R>> column2) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        BaseColumn<DataRow<Object>> baseColumn = $this$getColumn.getColumnOrNull(column2);
        if (baseColumn == null || (baseColumn = TypeConversionsKt.asGroupedT(baseColumn)) == null) {
            throw new IllegalArgumentException("ColumnGroup not found: '" + column2 + '\'');
        }
        return baseColumn;
    }

    @NotNull
    public static final <T, R> DataColumn<R> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, @NotNull ColumnReference<? extends R> column2) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        DataColumn<? extends R> dataColumn = $this$getColumn.getColumnOrNull(column2);
        if (dataColumn == null) {
            throw new IllegalArgumentException("Column not found: '" + column2 + '\'');
        }
        return dataColumn;
    }

    @NotNull
    public static final <T> DataColumn<?> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, @NotNull ColumnPath path) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DataColumn<?> dataColumn = $this$getColumn.getColumnOrNull(path);
        if (dataColumn == null) {
            throw new IllegalArgumentException("Column not found: '" + path + '\'');
        }
        return dataColumn;
    }

    @NotNull
    public static final <T> DataColumn<?> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, int index) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        DataColumn<?> dataColumn = $this$getColumn.getColumnOrNull(index);
        if (dataColumn == null) {
            throw new IllegalArgumentException("Column index is out of bounds: " + index + ". Columns count = " + DataFrameKt.getNcol($this$getColumn));
        }
        return dataColumn;
    }

    @NotNull
    public static final <T, C> DataColumn<C> getColumn(@NotNull ColumnsContainer<? extends T> $this$getColumn, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return $this$getColumn.get(selector);
    }

    @NotNull
    public static final <T> ColumnGroup<?> getColumnGroup(@NotNull ColumnsContainer<? extends T> $this$getColumnGroup, int index) {
        Intrinsics.checkNotNullParameter($this$getColumnGroup, (String)"<this>");
        return TypeConversionsKt.asColumnGroupUntyped(DataFrameGetKt.getColumn($this$getColumnGroup, index));
    }

    @NotNull
    public static final <T> ColumnGroup<?> getColumnGroup(@NotNull ColumnsContainer<? extends T> $this$getColumnGroup, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getColumnGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return TypeConversionsKt.asColumnGroupUntyped(DataFrameGetKt.getColumn($this$getColumnGroup, name));
    }

    @NotNull
    public static final <T> ColumnGroup<?> getColumnGroup(@NotNull ColumnsContainer<? extends T> $this$getColumnGroup, @NotNull KProperty<?> column2) {
        Intrinsics.checkNotNullParameter($this$getColumnGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DataFrameGetKt.getColumnGroup($this$getColumnGroup, UtilsKt.getColumnName(column2));
    }

    @NotNull
    public static final <T, C> ColumnGroup<C> getColumnGroup(@NotNull ColumnsContainer<? extends T> $this$getColumnGroup, @NotNull ColumnReference<? extends DataRow<? extends C>> column2) {
        Intrinsics.checkNotNullParameter($this$getColumnGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DataFrameGetKt.getColumn($this$getColumnGroup, column2);
    }

    @NotNull
    public static final <T, C> ColumnGroup<C> getColumnGroup(@NotNull ColumnsContainer<? extends T> $this$getColumnGroup, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends SingleColumn<? extends DataRow<? extends C>>> column2) {
        Intrinsics.checkNotNullParameter($this$getColumnGroup, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return TypeConversionsKt.asGroupedT($this$getColumnGroup.get(column2));
    }

    @Nullable
    public static final <T> ColumnGroup<?> getColumnGroupOrNull(@NotNull ColumnsContainer<? extends T> $this$getColumnGroupOrNull, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$getColumnGroupOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        DataColumn<?> dataColumn = $this$getColumnGroupOrNull.getColumnOrNull(name);
        return dataColumn != null ? TypeConversionsKt.asColumnGroupUntyped(dataColumn) : null;
    }

    @Nullable
    public static final <T> ColumnGroup<?> getColumnGroupOrNull(@NotNull ColumnsContainer<? extends T> $this$getColumnGroupOrNull, @NotNull KProperty<?> column2) {
        Intrinsics.checkNotNullParameter($this$getColumnGroupOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DataFrameGetKt.getColumnGroupOrNull($this$getColumnGroupOrNull, UtilsKt.getColumnName(column2));
    }

    public static final <C> boolean containsColumn(@NotNull ColumnsContainer<?> $this$containsColumn, @NotNull ColumnReference<? extends C> column2) {
        Intrinsics.checkNotNullParameter($this$containsColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return $this$containsColumn.getColumnOrNull(column2) != null;
    }

    public static final boolean containsColumn(@NotNull ColumnsContainer<?> $this$containsColumn, @NotNull KProperty<?> column2) {
        Intrinsics.checkNotNullParameter($this$containsColumn, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return $this$containsColumn.containsColumn(UtilsKt.getColumnName(column2));
    }

    public static final boolean contains(@NotNull ColumnsContainer<?> $this$contains, @NotNull ColumnReference<?> column2) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DataFrameGetKt.containsColumn($this$contains, column2);
    }

    public static final boolean contains(@NotNull ColumnsContainer<?> $this$contains, @NotNull KProperty<?> column2) {
        Intrinsics.checkNotNullParameter($this$contains, (String)"<this>");
        Intrinsics.checkNotNullParameter(column2, (String)"column");
        return DataFrameGetKt.containsColumn($this$contains, column2);
    }

    @NotNull
    public static final <T> Iterable<DataRow<T>> rows(@NotNull DataFrame<? extends T> $this$rows) {
        Intrinsics.checkNotNullParameter($this$rows, (String)"<this>");
        return new Iterable<DataRow<? extends T>>($this$rows){
            final /* synthetic */ DataFrame<T> $this_rows;
            {
                this.$this_rows = $receiver;
            }

            @NotNull
            public rows.iterator.1<T> iterator() {
                return new Iterator<DataRow<? extends T>>(this.$this_rows){
                    private int nextRow;
                    final /* synthetic */ DataFrame<T> $this_rows;
                    {
                        this.$this_rows = $receiver;
                    }

                    public final int getNextRow() {
                        return this.nextRow;
                    }

                    public final void setNextRow(int n) {
                        this.nextRow = n;
                    }

                    public boolean hasNext() {
                        return this.nextRow < DataFrameKt.getNrow(this.$this_rows);
                    }

                    @NotNull
                    public DataRow<T> next() {
                        if (!(this.nextRow < DataFrameKt.getNrow(this.$this_rows))) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        int n = this.nextRow;
                        this.nextRow = n + 1;
                        return this.$this_rows.get(n);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final <T> Iterable<DataRow<T>> rowsReversed(@NotNull DataFrame<? extends T> $this$rowsReversed) {
        Intrinsics.checkNotNullParameter($this$rowsReversed, (String)"<this>");
        return new Iterable<DataRow<? extends T>>($this$rowsReversed){
            final /* synthetic */ DataFrame<T> $this_rowsReversed;
            {
                this.$this_rowsReversed = $receiver;
            }

            @NotNull
            public rowsReversed.iterator.1<T> iterator() {
                return new Iterator<DataRow<? extends T>>(this.$this_rowsReversed){
                    private int nextRow;
                    final /* synthetic */ DataFrame<T> $this_rowsReversed;
                    {
                        this.$this_rowsReversed = $receiver;
                        this.nextRow = DataFrameKt.getNrow($receiver) - 1;
                    }

                    public final int getNextRow() {
                        return this.nextRow;
                    }

                    public final void setNextRow(int n) {
                        this.nextRow = n;
                    }

                    public boolean hasNext() {
                        return this.nextRow >= 0;
                    }

                    @NotNull
                    public DataRow<T> next() {
                        if (!(this.nextRow >= 0)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        int n = this.nextRow;
                        this.nextRow = n + -1;
                        return this.$this_rowsReversed.get(n);
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }
}

