/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.instrumentation.ClassWriterImpl;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.WeakHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.ConstantDynamic;
import org.jetbrains.coverage.org.objectweb.asm.FieldVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntellijClassfileTransformer
implements ClassFileTransformer {
    private final boolean computeFrames = this.computeFrames();
    private final WeakHashMap<ClassLoader, Map<String, ClassReader>> classReaders = new WeakHashMap();
    private long ourTime;
    private int ourClassCount;

    protected AbstractIntellijClassfileTransformer() {
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(this){
            final /* synthetic */ AbstractIntellijClassfileTransformer this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public void run() {
                void var1_1;
                double allTime = 1.0 * (double)this.this$0.ourTime / 1.0E9;
                ErrorReporter.printInfo("Class transformation time: " + allTime + "s for " + this.this$0.ourClassCount + " classes or " + (double)(var1_1 / (double)this.this$0.ourClassCount) + "s per class");
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        long s = System.nanoTime();
        try {
            void var3_4;
            void var2_3;
            byte[] byArray;
            byArray = this.transformInner((ClassLoader)byArray, (String)var2_3, classFileBuffer, (Class<?>)var3_4);
            return byArray;
        }
        finally {
            ++this.ourClassCount;
            this.ourTime += System.nanoTime() - s;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final byte[] transform(ClassLoader loader, String className, byte[] classFileBuffer, Class<?> classBeingRedefined) {
        if (className == null) {
            return null;
        }
        className = ClassNameUtil.removeClassSuffix(className);
        if ((className = ClassNameUtil.convertToFQName(className)).startsWith("com.intellij.rt.") || className.startsWith("org.jetbrains.coverage.gnu.trove.") || className.startsWith("org.jetbrains.coverage.org.objectweb.") || this.isInternalJavaClass(className)) {
            return null;
        }
        if (classBeingRedefined != null && this.classAlreadyHasCoverage(classFileBuffer)) {
            return null;
        }
        if (this.shouldExclude(className)) {
            return null;
        }
        this.visitClassLoader(loader);
        InclusionPattern inclusionPattern = this.getInclusionPattern();
        if (inclusionPattern == null) {
            if (loader != null) {
                return this.instrument(classFileBuffer, className, loader, this.computeFrames);
            }
        } else if (inclusionPattern.accept(className)) {
            void var1_1;
            void var2_2;
            void var3_3;
            return this.instrument((byte[])var3_3, (String)var2_2, (ClassLoader)var1_1, this.computeFrames);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private boolean classAlreadyHasCoverage(byte[] classFileBuffer) {
        void var2_2;
        void var1_1;
        boolean[] hasCoverage = new boolean[]{false};
        new ClassReader((byte[])var1_1).accept(new ClassVisitor(this, 589824, hasCoverage){
            final /* synthetic */ boolean[] val$hasCoverage;
            final /* synthetic */ AbstractIntellijClassfileTransformer this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$hasCoverage = blArray;
                super((int)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                void var3_3;
                void var2_2;
                void var1_1;
                if ("__$hits$__".equals(name)) {
                    this.val$hasCoverage[0] = true;
                }
                return super.visitField((int)var1_1, (String)var2_2, (String)var3_3, signature, value);
            }

            /*
             * WARNING - void declaration
             */
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                void var1_2;
                void var3_4;
                void var2_3;
                MethodVisitor methodVisitor = super.visitMethod(access, (String)var2_3, (String)var3_4, signature, exceptions);
                return new MethodVisitor(this, 589824, (MethodVisitor)var1_2){
                    final /* synthetic */ 2 this$1;
                    {
                        void var3_3;
                        void var2_2;
                        void var1_1;
                        this.this$1 = var1_1;
                        super((int)var2_2, (MethodVisitor)var3_3);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void visitLdcInsn(Object value) {
                        super.visitLdcInsn(value);
                        if (value instanceof ConstantDynamic) {
                            void var1_1;
                            ConstantDynamic condy = (ConstantDynamic)value;
                            if ("com/intellij/rt/coverage/util/CondyUtils".equals(var1_1.getDescriptor())) {
                                this.this$1.val$hasCoverage[0] = true;
                            }
                        }
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                        void var2_2;
                        void var3_3;
                        void var1_1;
                        super.visitMethodInsn((int)var1_1, owner, (String)var3_3, descriptor, isInterface);
                        if ("com/intellij/rt/coverage/instrumentation/CoverageRuntime".equals(var2_2)) {
                            this.this$1.val$hasCoverage[0] = true;
                        }
                    }
                };
            }
        }, 6);
        return (boolean)var2_2[0];
    }

    /*
     * WARNING - void declaration
     */
    private byte[] transformInner(ClassLoader loader, String className, byte[] classFileBuffer, Class<?> classBeingRedefined) {
        if (this.isStopped()) {
            return null;
        }
        try {
            void var3_5;
            return this.transform(loader, className, (byte[])var3_5, classBeingRedefined);
        }
        catch (ClassWriterImpl.FrameComputationClassNotFoundException e) {
            ErrorReporter.info("Error during class frame computation: " + className, e);
        }
        catch (Throwable e) {
            void var1_3;
            void var2_4;
            ErrorReporter.warn("Error during class instrumentation: " + (String)var2_4, (Throwable)var1_3);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isInternalJavaClass(String className) {
        void var1_1;
        return className.startsWith("java.") || className.startsWith("sun.") || className.startsWith("com.sun.") || var1_1.startsWith("jdk.");
    }

    /*
     * WARNING - void declaration
     */
    public byte[] instrument(byte[] classfileBuffer, String className, ClassLoader loader, boolean computeFrames) {
        void var1_1;
        void var3_3;
        void var2_2;
        ClassWriterImpl cw;
        ClassReader cr = new ClassReader(classfileBuffer);
        if (computeFrames) {
            int version = AbstractIntellijClassfileTransformer.getClassFileVersion(cr);
            int flags = (version & 0xFFFF) >= 50 && version != 196653 ? 2 : 1;
            cw = new ClassWriterImpl(flags, loader, this.classReaders);
        } else {
            cw = new ClassWriterImpl(1, loader, this.classReaders);
        }
        ClassVisitor cv = this.createClassVisitor((String)var2_2, (ClassLoader)var3_3, cr, cw);
        if (cv == null) {
            return null;
        }
        var1_1.accept(cv, 8);
        return cw.toByteArray();
    }

    protected abstract ClassVisitor createClassVisitor(String var1, ClassLoader var2, ClassReader var3, ClassVisitor var4);

    protected abstract boolean shouldExclude(String var1);

    protected InclusionPattern getInclusionPattern() {
        return null;
    }

    protected void visitClassLoader(ClassLoader classLoader) {
    }

    protected boolean isStopped() {
        return false;
    }

    private boolean computeFrames() {
        return System.getProperty("idea.coverage.no.frames") == null;
    }

    private static int getClassFileVersion(ClassReader reader) {
        return reader.readInt(4);
    }

    public static interface InclusionPattern {
        public boolean accept(String var1);
    }
}

