/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grid.scripting.impl;

import com.intellij.database.extensions.DataConsumer;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.grid.scripting.impl.DatabaseExtensionScriptRunnerInIde;
import com.intellij.grid.scripting.impl.LoaderScriptRunnerImplKt;
import com.intellij.grid.scripting.impl.RestrictedScriptRunnerService;
import com.intellij.grid.scripting.rt.bindings.Loader;
import com.intellij.grid.scripting.rt.util.DatabaseExtensionScriptRunnerBase;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableConsumer;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/grid/scripting/impl/LoaderScriptRunnerImpl;", "Lcom/intellij/grid/scripting/impl/RestrictedScriptRunnerService$LoaderScriptRunner;", "scriptPath", "Ljava/nio/file/Path;", "dependenciesProgressConsumer", "Lcom/intellij/grid/scripting/rt/util/DatabaseExtensionScriptRunnerBase$ProgressMessagesConsumer;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/grid/scripting/rt/util/DatabaseExtensionScriptRunnerBase$ProgressMessagesConsumer;)V", "loader", "Lcom/intellij/grid/scripting/impl/LoaderScriptRunnerImpl$LoaderImpl;", "runLoad", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "", "dataConsumer", "Lcom/intellij/database/extensions/DataConsumer;", "cleanup", "LoadContextImpl", "LoaderImpl", "intellij.grid.scripting.impl"})
public final class LoaderScriptRunnerImpl
implements RestrictedScriptRunnerService.LoaderScriptRunner {
    @NotNull
    private final LoaderImpl loader;

    public LoaderScriptRunnerImpl(@NotNull Path scriptPath, @NotNull DatabaseExtensionScriptRunnerBase.ProgressMessagesConsumer dependenciesProgressConsumer) {
        Intrinsics.checkNotNullParameter((Object)scriptPath, (String)"scriptPath");
        Intrinsics.checkNotNullParameter((Object)dependenciesProgressConsumer, (String)"dependenciesProgressConsumer");
        DatabaseExtensionScriptRunnerInIde runner = new DatabaseExtensionScriptRunnerInIde(scriptPath, dependenciesProgressConsumer);
        this.loader = new LoaderImpl(runner);
        runner.bind("LOADER", this.loader);
        try {
            ExtensionScriptsUtil.evalScript(null, (IdeScriptEngine)runner.getEngine(), (Path)scriptPath);
        }
        catch (ProcessCanceledException c) {
            throw c;
        }
        catch (Throwable e) {
            LoaderScriptRunnerImplKt.access$getLogger$p().warn(e);
            if (e.getCause() instanceof ProcessCanceledException) {
                ExceptionUtil.rethrow((Throwable)e.getCause());
            }
            throw e;
        }
    }

    @Override
    public void runLoad(@NotNull Project project, @NotNull Map<String, ? extends Object> parameters, @NotNull DataConsumer dataConsumer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)dataConsumer, (String)"dataConsumer");
        this.loader.runLoad(project, parameters, new Loader.DataConsumer(dataConsumer){
            final /* synthetic */ DataConsumer $dataConsumer;
            {
                this.$dataConsumer = $dataConsumer;
            }

            public void consumeColumns(String[] names, Class<?>[] types) {
                this.$dataConsumer.consumeColumns(names, (Class[])types);
            }

            public void consume(Object ... row) {
                Intrinsics.checkNotNullParameter((Object)row, (String)"row");
                this.$dataConsumer.consume(Arrays.copyOf(row, row.length));
            }
        });
    }

    @Override
    public void cleanup() {
        this.loader.cleanup();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\t\u0010\r\u001a\u00020\u0007H\u00c2\u0003J)\u0010\u000e\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0004H\u00d6\u0001R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/grid/scripting/impl/LoaderScriptRunnerImpl$LoadContextImpl;", "Lcom/intellij/grid/scripting/rt/bindings/Loader$LoadContext;", "parameters", "", "", "", "consumer", "Lcom/intellij/grid/scripting/rt/bindings/Loader$DataConsumer;", "<init>", "(Ljava/util/Map;Lcom/intellij/grid/scripting/rt/bindings/Loader$DataConsumer;)V", "getParameters", "getDataConsumer", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.grid.scripting.impl"})
    private static final class LoadContextImpl
    implements Loader.LoadContext {
        @NotNull
        private final Map<String, Object> parameters;
        @NotNull
        private final Loader.DataConsumer consumer;

        public LoadContextImpl(@NotNull Map<String, ? extends Object> parameters, @NotNull Loader.DataConsumer consumer) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
            this.parameters = parameters;
            this.consumer = consumer;
        }

        @NotNull
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @NotNull
        public Loader.DataConsumer getDataConsumer() {
            return this.consumer;
        }

        private final Map<String, Object> component1() {
            return this.parameters;
        }

        private final Loader.DataConsumer component2() {
            return this.consumer;
        }

        @NotNull
        public final LoadContextImpl copy(@NotNull Map<String, ? extends Object> parameters, @NotNull Loader.DataConsumer consumer) {
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
            return new LoadContextImpl(parameters, consumer);
        }

        public static /* synthetic */ LoadContextImpl copy$default(LoadContextImpl loadContextImpl, Map map, Loader.DataConsumer dataConsumer, int n, Object object) {
            if ((n & 1) != 0) {
                map = loadContextImpl.parameters;
            }
            if ((n & 2) != 0) {
                dataConsumer = loadContextImpl.consumer;
            }
            return loadContextImpl.copy(map, dataConsumer);
        }

        @NotNull
        public String toString() {
            return "LoadContextImpl(parameters=" + this.parameters + ", consumer=" + this.consumer + ")";
        }

        public int hashCode() {
            int result = ((Object)this.parameters).hashCode();
            result = result * 31 + this.consumer.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoadContextImpl)) {
                return false;
            }
            LoadContextImpl loadContextImpl = (LoadContextImpl)other;
            if (!Intrinsics.areEqual(this.parameters, loadContextImpl.parameters)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.consumer, (Object)loadContextImpl.consumer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u000b\u001a\u00020\u000f2\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\tj\u0002`\n0\u0007H\u0016J\u0006\u0010\u0018\u001a\u00020\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\tj\u0002`\n0\u00072\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u00060\tj\u0002`\n0\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/intellij/grid/scripting/impl/LoaderScriptRunnerImpl$LoaderImpl;", "Lcom/intellij/grid/scripting/rt/bindings/Loader;", "runner", "Lcom/intellij/grid/scripting/impl/DatabaseExtensionScriptRunnerInIde;", "<init>", "(Lcom/intellij/grid/scripting/impl/DatabaseExtensionScriptRunnerInIde;)V", "value", "Lcom/intellij/util/ThrowableConsumer;", "Lcom/intellij/grid/scripting/rt/bindings/Loader$LoadContext;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "load", "getLoad", "()Lcom/intellij/util/ThrowableConsumer;", "runLoad", "", "project", "Lcom/intellij/openapi/project/Project;", "parameters", "", "", "", "dataConsumer", "Lcom/intellij/grid/scripting/rt/bindings/Loader$DataConsumer;", "cleanup", "intellij.grid.scripting.impl"})
    private static final class LoaderImpl
    implements Loader {
        @NotNull
        private final DatabaseExtensionScriptRunnerInIde runner;
        @NotNull
        private ThrowableConsumer<Loader.LoadContext, Exception> load;

        public LoaderImpl(@NotNull DatabaseExtensionScriptRunnerInIde runner) {
            Intrinsics.checkNotNullParameter((Object)((Object)runner), (String)"runner");
            this.runner = runner;
            this.load = LoaderImpl::load$lambda$0;
        }

        @NotNull
        public final ThrowableConsumer<Loader.LoadContext, Exception> getLoad() {
            return this.load;
        }

        public final void runLoad(@NotNull Project project, @NotNull Map<String, ? extends Object> parameters, @NotNull Loader.DataConsumer dataConsumer) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
            Intrinsics.checkNotNullParameter((Object)dataConsumer, (String)"dataConsumer");
            this.runner.callBack(() -> LoaderImpl.runLoad$lambda$1(this, parameters, dataConsumer));
        }

        public void load(@NotNull ThrowableConsumer<Loader.LoadContext, Exception> load2) {
            Intrinsics.checkNotNullParameter(load2, (String)"load");
            this.load = load2;
        }

        public final void cleanup() {
            this.runner.cleanup();
        }

        private static final void load$lambda$0(Loader.LoadContext it) {
        }

        private static final Unit runLoad$lambda$1(LoaderImpl this$0, Map $parameters, Loader.DataConsumer $dataConsumer) {
            this$0.load.consume((Object)new LoadContextImpl($parameters, $dataConsumer));
            return Unit.INSTANCE;
        }
    }
}

