/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.frameworks.modules.JSRemoteModuleReference;
import com.intellij.lang.javascript.frameworks.modules.JSUrlImportsUtil;
import com.intellij.lang.javascript.library.JSLibReferenceResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSXmlLibraryReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JSXmlLibraryReferenceContributor.$$$reportNull$$$0(0);
        }
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"src", "href"}, (ElementFilter)new ElementFilter(){

            public boolean isAcceptable(Object element2, PsiElement context2) {
                if (!(element2 instanceof XmlAttributeValue)) {
                    return false;
                }
                XmlAttributeValue value = (XmlAttributeValue)element2;
                PsiElement attribute = value.getParent();
                if (attribute instanceof XmlAttribute && JSXmlLibraryReferenceContributor.isLibraryReferenceAttribute((XmlAttribute)attribute, value)) {
                    return JSLibraryUtil.containsLibURL(value.getValue());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }, (PsiReferenceProvider)new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
                if (element2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (element2 instanceof XmlAttributeValue) {
                    PsiReference[] psiReferenceArray = new PsiReference[]{JSLibReferenceResolver.createReference((XmlAttributeValue)element2)};
                    if (psiReferenceArray == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    2.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/library/JSXmlLibraryReferenceContributor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/library/JSXmlLibraryReferenceContributor$2";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
        XmlUtil.registerXmlAttributeValueReferenceProvider((PsiReferenceRegistrar)registrar, (String[])new String[]{"src"}, (ElementFilter)new ElementFilter(){

            public boolean isAcceptable(Object element2, PsiElement context2) {
                if (!(element2 instanceof XmlAttributeValue)) {
                    return false;
                }
                XmlAttributeValue value = (XmlAttributeValue)element2;
                XmlAttribute attribute = (XmlAttribute)ObjectUtils.tryCast((Object)value.getParent(), XmlAttribute.class);
                if (attribute != null && JSUrlImportsUtil.isRemoteModuleReferenceAttribute(attribute, value)) {
                    return JSUrlImportsUtil.isSupportedRemoteModuleUrl(value.getValue());
                }
                return false;
            }

            public boolean isClassAcceptable(Class hintClass) {
                return true;
            }
        }, (PsiReferenceProvider)new PsiReferenceProvider(){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
                if (element2 == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (context2 == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (element2 instanceof XmlAttributeValue) {
                    XmlAttributeValue attributeValue = (XmlAttributeValue)element2;
                    PsiReference[] psiReferenceArray = new PsiReference[]{new JSRemoteModuleReference(element2, attributeValue.getValue(), attributeValue.getValueTextRange().getStartOffset() - element2.getTextRange().getStartOffset()){

                        @Override
                        public boolean isSoft() {
                            return true;
                        }
                    }};
                    if (psiReferenceArray == null) {
                        4.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    4.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/library/JSXmlLibraryReferenceContributor$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/library/JSXmlLibraryReferenceContributor$4";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
    }

    public static boolean isLibraryReferenceAttribute(@NotNull XmlAttribute attribute, @Nullable XmlAttributeValue value) {
        if (attribute == null) {
            JSXmlLibraryReferenceContributor.$$$reportNull$$$0(1);
        }
        return JSXmlLibraryReferenceContributor.isLinkLibraryReference(attribute) || JSXmlLibraryReferenceContributor.isScriptLibraryReference(attribute, value);
    }

    private static boolean isLinkLibraryReference(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            JSXmlLibraryReferenceContributor.$$$reportNull$$$0(2);
        }
        return "href".equals(attribute.getName()) && "link".equals(attribute.getParent().getName());
    }

    private static boolean isScriptLibraryReference(@NotNull XmlAttribute attribute, @Nullable XmlAttributeValue attributeValue) {
        if (attribute == null) {
            JSXmlLibraryReferenceContributor.$$$reportNull$$$0(3);
        }
        if (!"src".equals(attribute.getName())) {
            return false;
        }
        XmlTag tag = attribute.getParent();
        return HtmlUtil.isScriptTag((XmlTag)tag) && !JSUrlImportsUtil.isModuleContext(tag, attributeValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/library/JSXmlLibraryReferenceContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isLibraryReferenceAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isLinkLibraryReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isScriptLibraryReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

