/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.connectionFrame;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.remoteDev.util.LifetimeExKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.gateway.api.GatewayConnectionHandle;
import com.jetbrains.gateway.api.GatewayUI;
import com.jetbrains.gateway.connection.GatewayConnectionFrameManager;
import com.jetbrains.gateway.connectionFrame.ConnectionFrame;
import com.jetbrains.gateway.thinClientLink.ThinClientHandle;
import com.jetbrains.gateway.welcomeScreen.GatewayWelcomeFrame;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\u0007\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t\u0012\f\u0012\n \n*\u0004\u0018\u00010\u000b0\u000b\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/connectionFrame/ConnectionFrameManagerImpl;", "Lcom/jetbrains/gateway/connection/GatewayConnectionFrameManager;", "<init>", "()V", "frames", "", "Lcom/intellij/openapi/Disposable;", "usedHandles", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "Lcom/jetbrains/gateway/thinClientLink/ThinClientHandle;", "kotlin.jvm.PlatformType", "", "create", "handle", "Lcom/jetbrains/gateway/api/GatewayConnectionHandle;", "closeWelcomeFrame", "get", "", "Companion", "intellij.gateway"})
@SourceDebugExtension(value={"SMAP\nConnectionFrameManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionFrameManagerImpl.kt\ncom/jetbrains/gateway/connectionFrame/ConnectionFrameManagerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,59:1\n14#2:60\n*S KotlinDebug\n*F\n+ 1 ConnectionFrameManagerImpl.kt\ncom/jetbrains/gateway/connectionFrame/ConnectionFrameManagerImpl\n*L\n20#1:60\n*E\n"})
public final class ConnectionFrameManagerImpl
implements GatewayConnectionFrameManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Disposable> frames = new ArrayList();
    private final ConcurrentHashMap.KeySetView<ThinClientHandle, Unit> usedHandles = new ConcurrentHashMap().keySet(Unit.INSTANCE);
    @NotNull
    private static final Logger logger;

    public void create(@NotNull GatewayConnectionHandle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        ThinClientHandle clientHandle = handle.getClientHandle();
        if (clientHandle != null) {
            if (this.usedHandles.add(clientHandle)) {
                LifetimeExKt.onTerminationOrNow((Lifetime)handle.getLifetime(), () -> ConnectionFrameManagerImpl.create$lambda$0(this, clientHandle));
            } else {
                return;
            }
        }
        ThreadingAssertions.assertEventDispatchThread();
        logger.debug("Create connection frame for " + handle.getTitle());
        handle.getLifetime().onTermination(() -> ConnectionFrameManagerImpl.create$lambda$1(handle));
        Disposable disposable = handle.customConnectionFrame();
        if (disposable == null) {
            disposable = new ConnectionFrame(handle);
        }
        Disposable frame = disposable;
        CollectionExKt.addUnique((Collection)this.frames, (Lifetime)handle.getLifetime(), (Object)frame);
    }

    public void closeWelcomeFrame() {
        ThreadingAssertions.assertEventDispatchThread();
        if (Registry.Companion.is("gateway.close.welcome.frame.after.connection")) {
            IdeFrame ideFrame = WelcomeFrame.Companion.getInstance();
            Intrinsics.checkNotNull((Object)ideFrame, (String)"null cannot be cast to non-null type com.jetbrains.gateway.welcomeScreen.GatewayWelcomeFrame");
            ((GatewayWelcomeFrame)ideFrame).close();
        } else {
            GatewayUI.Companion.getInstance().reset();
        }
    }

    @NotNull
    public final List<Disposable> get() {
        return CollectionsKt.toList((Iterable)this.frames);
    }

    private static final Unit create$lambda$0(ConnectionFrameManagerImpl this$0, ThinClientHandle $clientHandle) {
        this$0.usedHandles.remove($clientHandle);
        return Unit.INSTANCE;
    }

    private static final Unit create$lambda$1(GatewayConnectionHandle $handle) {
        logger.debug("Close connection frame for " + $handle.getTitle());
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConnectionFrameManagerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ConnectionFrameManagerImpl.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/connectionFrame/ConnectionFrameManagerImpl$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gateway"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

